/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.common;

import java.util.Comparator;
import org.hy.common.Help;
import org.hy.common.StringHelp;

public class TreeIDHelp
implements Comparator<String> {
    private String split = ".";
    private int rootLevel = 1;
    private int minIndexNo = 1;

    public TreeIDHelp() {
    }

    public TreeIDHelp(int i_RootLevel, int i_MinIndexNo) {
        this(".", i_RootLevel, i_MinIndexNo);
    }

    public TreeIDHelp(String i_Split) {
        this(i_Split, 1, 1);
    }

    public TreeIDHelp(String i_Split, int i_RootLevel, int i_MinIndexNo) {
        this.checkSplitIndexNo(i_Split, i_MinIndexNo);
        this.rootLevel = i_RootLevel;
        this.minIndexNo = i_MinIndexNo;
        this.split = i_Split;
    }

    public String getRootID() {
        return this.getTreeID(null, this.minIndexNo);
    }

    public String getRootID(int i_IndexNo) {
        return this.getTreeID(null, i_IndexNo);
    }

    public String getTreeID(String i_SuperTreeID, int i_IndexNo) {
        if (this.minIndexNo > i_IndexNo) {
            throw new IllegalArgumentException("IndexNo[" + i_IndexNo + "] is less than MinIndexNo[" + this.minIndexNo + "]");
        }
        this.checkSplitIndexNo(this.split, i_IndexNo);
        if (Help.isNull((String)i_SuperTreeID)) {
            return "" + i_IndexNo;
        }
        return i_SuperTreeID + this.split + i_IndexNo;
    }

    public int getLevel(String i_TreeID) {
        if (Help.isNull((String)i_TreeID)) {
            throw new NullPointerException("TreeID is null.");
        }
        String v_TreeID = i_TreeID.trim();
        return StringHelp.split((String)v_TreeID, (String)this.split).length + this.rootLevel - 1;
    }

    public int getIndexNo(String i_TreeID) {
        if (Help.isNull((String)i_TreeID)) {
            throw new NullPointerException("TreeID is null.");
        }
        String v_TreeID = i_TreeID.trim();
        String[] v_IDs = StringHelp.split((String)v_TreeID, (String)this.split);
        int v_Index = v_IDs.length - 1;
        return Integer.parseInt(v_IDs[v_Index]);
    }

    public int getIndexNo(String i_TreeID, int i_Level) {
        if (Help.isNull((String)i_TreeID)) {
            throw new NullPointerException("TreeID is null.");
        }
        if (i_Level < this.rootLevel) {
            throw new IllegalArgumentException("Level[" + i_Level + "] is less than RootLevel[" + this.rootLevel + "]");
        }
        int v_MaxLevel = this.getLevel(i_TreeID);
        if (v_MaxLevel < i_Level) {
            throw new IllegalArgumentException("Level[" + i_Level + "] is greater than MaxLevel[" + v_MaxLevel + "]");
        }
        String v_TreeID = i_TreeID.trim();
        String[] v_IDs = StringHelp.split((String)v_TreeID, (String)this.split);
        int v_Index = i_Level - this.rootLevel;
        return Integer.parseInt(v_IDs[v_Index]);
    }

    public String getSuperTreeID(String i_TreeID) {
        if (Help.isNull((String)i_TreeID)) {
            throw new NullPointerException("TreeID is null.");
        }
        String v_TreeID = i_TreeID.trim();
        int v_Index = v_TreeID.lastIndexOf(this.split);
        if (v_Index <= 0) {
            return "";
        }
        return v_TreeID.substring(0, v_Index);
    }

    public String getSplit() {
        return this.split;
    }

    private void checkSplitIndexNo(String i_Split, int i_IndexNo) {
        char[] v_SplitArr = this.split.toCharArray();
        String v_IndexNo = "" + i_IndexNo;
        for (char v_SplitChar : v_SplitArr) {
            if (!StringHelp.isContains((String)v_IndexNo, (String[])new String[]{StringHelp.toString((char)v_SplitChar)})) continue;
            throw new IllegalArgumentException("IndexNo[" + i_IndexNo + "] contains split[" + this.split + "]'s [" + StringHelp.toString((char)v_SplitChar) + "]");
        }
    }

    public int getRootLevel() {
        return this.rootLevel;
    }

    public int getMinIndexNo() {
        return this.minIndexNo;
    }

    @Override
    public int compare(String i_ATreeID, String i_BTreeID) {
        if (i_ATreeID == null) {
            return i_BTreeID == null ? 0 : -1;
        }
        if (i_BTreeID == null) {
            return 1;
        }
        if (i_ATreeID.equals(i_BTreeID)) {
            return 0;
        }
        String[] v_ATreeID = StringHelp.split((String)i_ATreeID, (String)this.split);
        String[] v_BTreeID = StringHelp.split((String)i_BTreeID, (String)this.split);
        int v_Size = Help.min((Integer)v_ATreeID.length, (Integer[])new Integer[]{v_BTreeID.length});
        for (int x = 0; x < v_Size; ++x) {
            Integer v_BNo;
            Integer v_ANo = Integer.valueOf(v_ATreeID[x]);
            int v_CompareTo = v_ANo.compareTo(v_BNo = Integer.valueOf(v_BTreeID[x]));
            if (v_CompareTo == 0) continue;
            return v_CompareTo;
        }
        return Integer.compare(v_ATreeID.length, v_BTreeID.length);
    }
}

