/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.cache;

import java.util.HashMap;
import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.PartitionMap;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.TablePartitionLink;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.cache.CacheFactory;
import org.hy.common.callflow.cache.ICache;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.ExportType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.redis.IRedis;
import org.hy.common.xml.XJSON;
import org.hy.common.xml.XJava;
import org.hy.common.xml.log.Logger;

public class CacheSetConfig
extends ExecuteElement
implements Cloneable {
    private static final Logger $Logger = new Logger(CacheSetConfig.class);
    private String cacheXID;
    private String dataBase;
    private String table;
    private String pkID;
    private String rowData;
    private PartitionMap<String, Integer> rowDataPlaceholders;
    private Boolean nullDel = false;
    private String expireTime = "0";
    private Boolean allowDelTable = false;
    private ICache<?> cache;
    private boolean isInit = false;

    public CacheSetConfig() {
        this(0L, 0L);
    }

    public CacheSetConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    public String getCacheXID() {
        if (Help.isNull((String)this.cacheXID)) {
            return null;
        }
        return ":" + this.cacheXID;
    }

    public void setCacheXID(String i_CacheXID) {
        this.cacheXID = ValueHelp.standardValueID(i_CacheXID);
        this.isInit = false;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    private synchronized ICache<?> gatCache() {
        if (!this.isInit) {
            Object v_Cache;
            this.cache = !Help.isNull((String)this.cacheXID) ? ((v_Cache = XJava.getObject((String)this.cacheXID)) == null ? CacheFactory.newInstanceOf(null, Object.class) : (v_Cache instanceof IRedis ? CacheFactory.newInstanceOf((IRedis)v_Cache, Object.class) : CacheFactory.newInstanceOf(null, Object.class))) : CacheFactory.newInstanceOf(null, Object.class);
            this.isInit = true;
        }
        return this.cache;
    }

    public String getDataBase() {
        return this.dataBase;
    }

    public void setDataBase(String i_DataBase) {
        this.dataBase = i_DataBase;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String i_Table) {
        this.table = i_Table;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getPkID() {
        return this.pkID;
    }

    public void setPkID(String i_PkID) {
        this.pkID = i_PkID;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getRowData() {
        return this.rowData;
    }

    public void setRowData(String i_RowData) {
        PartitionMap v_PlaceholdersOrg = null;
        if (!Help.isNull((String)i_RowData)) {
            v_PlaceholdersOrg = StringHelp.parsePlaceholdersSequence((String)":", (String)i_RowData, (boolean)true);
        }
        if (!Help.isNull(v_PlaceholdersOrg)) {
            this.rowDataPlaceholders = Help.toReverse((PartitionMap)v_PlaceholdersOrg);
            v_PlaceholdersOrg.clear();
            v_PlaceholdersOrg = null;
        } else {
            this.rowDataPlaceholders = new TablePartitionLink();
        }
        this.rowData = i_RowData;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Boolean getNullDel() {
        return this.nullDel;
    }

    public void setNullDel(Boolean i_NullDel) {
        this.nullDel = i_NullDel;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(String i_ExpireTime) {
        this.expireTime = i_ExpireTime;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Boolean getAllowDelTable() {
        return this.allowDelTable;
    }

    public void setAllowDelTable(Boolean i_AllowDelTable) {
        this.allowDelTable = i_AllowDelTable;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    @Override
    public String getElementType() {
        return ElementType.CacheSet.getValue();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        long v_BeginTime = this.request();
        ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context));
        this.refreshStatus(io_Context, v_Result.getStatus());
        try {
            void var6_29;
            block28: {
                Object v_RowData;
                Long v_ExpireTime;
                String v_PKID;
                block35: {
                    String v_RowText;
                    block36: {
                        block34: {
                            block29: {
                                String v_DataBase;
                                block30: {
                                    String v_Table;
                                    block31: {
                                        Object v_RowData2;
                                        Long v_ExpireTime2;
                                        String v_PKID2;
                                        block33: {
                                            block32: {
                                                if (!this.handleContext(io_Context, v_Result)) {
                                                    return v_Result;
                                                }
                                                this.gatCache();
                                                Object var6_5 = null;
                                                if (Help.isNull((String)this.dataBase)) break block29;
                                                v_DataBase = (String)ValueHelp.getValue(this.dataBase, String.class, "", io_Context);
                                                if (Help.isNull((String)v_DataBase)) {
                                                    v_Result.setException(new RuntimeException(this.getXid() + " database[" + this.dataBase + "] is not exists."));
                                                    this.refreshStatus(io_Context, v_Result.getStatus());
                                                    return v_Result;
                                                }
                                                if (Help.isNull((String)this.table)) break block30;
                                                v_Table = (String)ValueHelp.getValue(this.table, String.class, "", io_Context);
                                                if (Help.isNull((String)v_Table)) {
                                                    v_Result.setException(new RuntimeException(this.getXid() + " table[" + this.table + "] is not exists."));
                                                    this.refreshStatus(io_Context, v_Result.getStatus());
                                                    return v_Result;
                                                }
                                                if (Help.isNull((String)this.pkID)) break block31;
                                                v_PKID2 = (String)ValueHelp.getValue(this.pkID, String.class, "", io_Context);
                                                if (Help.isNull((String)v_PKID2)) {
                                                    v_Result.setException(new RuntimeException(this.getXid() + " pkID[" + this.pkID + "] is not exists."));
                                                    this.refreshStatus(io_Context, v_Result.getStatus());
                                                    return v_Result;
                                                }
                                                v_ExpireTime2 = (Long)ValueHelp.getValue(this.expireTime, Long.class, 0L, io_Context);
                                                if (v_ExpireTime2 == null || v_ExpireTime2 < 0L) {
                                                    v_ExpireTime2 = 0L;
                                                }
                                                if ((v_RowData2 = this.gatRowData(io_Context)) != null) break block32;
                                                Long l = this.cache.delete(v_DataBase, v_Table, v_PKID2);
                                                break block28;
                                            }
                                            if (!(v_RowData2 instanceof String)) break block33;
                                            String v_RowText2 = (String)v_RowData2;
                                            if (Help.isNull((String)v_RowText2)) {
                                                Long l = this.cache.delete(v_DataBase, v_Table, v_PKID2);
                                                break block28;
                                            } else {
                                                if (!XJSON.isJson((String)v_RowText2)) {
                                                    v_Result.setException(new RuntimeException(this.getXid() + " rowData[" + v_RowText2 + "] is a text ,but it is not in JSON format."));
                                                    this.refreshStatus(io_Context, v_Result.getStatus());
                                                    return v_Result;
                                                }
                                                XJSON v_XJson = new XJSON();
                                                Map v_RowMap = (Map)v_XJson.toJava(v_RowText2, HashMap.class);
                                                if (Help.isNull((Map)v_RowMap)) {
                                                    Long l = this.cache.delete(v_DataBase, v_Table, v_PKID2);
                                                    break block28;
                                                } else {
                                                    Long l = this.cache.save(v_DataBase, v_Table, v_PKID2, v_RowMap, v_ExpireTime2);
                                                }
                                            }
                                            break block28;
                                        }
                                        Long l = this.cache.save(v_DataBase, v_Table, v_PKID2, v_RowData2, this.nullDel, v_ExpireTime2);
                                        break block28;
                                    }
                                    if (!this.allowDelTable.booleanValue()) {
                                        v_Result.setException(new RuntimeException(this.getXid() + " drop table[" + v_DataBase + "->" + v_Table + "] is not allowed."));
                                        this.refreshStatus(io_Context, v_Result.getStatus());
                                        return v_Result;
                                    }
                                    Boolean bl = this.cache.dropTable(v_DataBase, v_Table);
                                    break block28;
                                }
                                if (!this.allowDelTable.booleanValue()) {
                                    v_Result.setException(new RuntimeException(this.getXid() + " drop database[" + v_DataBase + "] is not allowed."));
                                    this.refreshStatus(io_Context, v_Result.getStatus());
                                    return v_Result;
                                }
                                Boolean bl = this.cache.dropDatabase(v_DataBase);
                                break block28;
                            }
                            if (Help.isNull((String)this.pkID)) break block28;
                            v_PKID = (String)ValueHelp.getValue(this.pkID, String.class, "", io_Context);
                            if (Help.isNull((String)v_PKID)) {
                                v_Result.setException(new RuntimeException(this.getXid() + " pkID[" + this.pkID + "] is not exists."));
                                this.refreshStatus(io_Context, v_Result.getStatus());
                                return v_Result;
                            }
                            v_ExpireTime = (Long)ValueHelp.getValue(this.expireTime, Long.class, 0L, io_Context);
                            if (v_ExpireTime == null || v_ExpireTime < 0L) {
                                v_ExpireTime = 0L;
                            }
                            if ((v_RowData = this.gatRowData(io_Context)) != null) break block34;
                            Long l = this.cache.del(v_PKID);
                            break block28;
                        }
                        if (!(v_RowData instanceof String)) break block35;
                        v_RowText = (String)v_RowData;
                        if (!Help.isNull((String)v_RowText)) break block36;
                        Long l = this.cache.del(v_PKID);
                        break block28;
                    }
                    if (v_ExpireTime > 0L) {
                        if (this.cache.setex(v_PKID, v_RowText, v_ExpireTime).booleanValue()) {
                            Long l = 1L;
                            break block28;
                        } else {
                            Long l = 0L;
                        }
                        break block28;
                    } else if (this.cache.set(v_PKID, v_RowText).booleanValue()) {
                        Long l = 1L;
                        break block28;
                    } else {
                        Long l = 0L;
                    }
                    break block28;
                }
                String v_RowText = v_RowData.toString();
                if (v_ExpireTime > 0L) {
                    if (this.cache.setex(v_PKID, v_RowText, v_ExpireTime).booleanValue()) {
                        Long l = 1L;
                    } else {
                        Long l = 0L;
                    }
                } else if (this.cache.set(v_PKID, v_RowText).booleanValue()) {
                    Long l = 1L;
                } else {
                    Long l = 0L;
                }
            }
            v_Result.setResult(var6_29);
            this.refreshReturn(io_Context, v_Result.getResult());
            this.refreshStatus(io_Context, v_Result.getStatus());
            this.success(Date.getTimeNano() - v_BeginTime);
            return v_Result;
        }
        catch (Exception exception) {
            v_Result.setException(exception);
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
    }

    private Object gatRowData(Map<String, Object> io_Context) throws Exception {
        if (Help.isNull(this.rowDataPlaceholders)) {
            return this.rowData;
        }
        if (this.rowDataPlaceholders.size() == 1) {
            String v_Key = ":" + (String)this.rowDataPlaceholders.keySet().iterator().next();
            if (this.rowData.equals(v_Key)) {
                return ValueHelp.getValue(this.rowData, null, null, io_Context);
            }
            return ValueHelp.replaceByContext(this.rowData, this.rowDataPlaceholders, io_Context);
        }
        return ValueHelp.replaceByContext(this.rowData, this.rowDataPlaceholders, io_Context);
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID, ExportType i_ExportType) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = ElementType.CacheSet.getXmlName();
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            if (ExportType.UI.equals((Object)i_ExportType)) {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginThis(v_XName, this.getXJavaID()));
            } else {
                v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
            }
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level, i_ExportType));
        if (!ExportType.UI.equals((Object)i_ExportType)) {
            if (!Help.isNull((String)this.cacheXID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("cacheXID", this.getCacheXID()));
            }
            if (!Help.isNull((String)this.dataBase)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("dataBase", this.dataBase));
            }
            if (!Help.isNull((String)this.table)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("table", this.table));
            }
            if (!Help.isNull((String)this.pkID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("pkID", this.pkID));
            }
            if (!Help.isNull((String)this.rowData)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("rowData", this.rowData, v_NewSpace));
            }
            if (this.nullDel != null && this.nullDel.booleanValue()) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("nullDel", this.nullDel));
            }
            if (!Help.isNull((String)this.expireTime) && !"0".equals(this.expireTime)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("expireTime", this.expireTime));
            }
            if (this.allowDelTable != null && this.allowDelTable.booleanValue()) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("allowDelTable", this.allowDelTable));
            }
            if (!Help.isNull((String)this.returnID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("returnID", this.returnID));
            }
            if (!Help.isNull((String)this.statusID)) {
                v_Xml.append(v_NewSpace).append(IToXml.toValue("statusID", this.statusID));
            }
            if (!Help.isNull(this.route.getSucceeds()) || !Help.isNull(this.route.getExceptions())) {
                v_Xml.append(v_NewSpace).append(IToXml.toBegin("route"));
                this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), RouteType.Succeed.getXmlName(), i_Level, v_TreeID, i_ExportType);
                this.toXmlRouteItems(v_Xml, this.route.getExceptions(), RouteType.Error.getXmlName(), i_Level, v_TreeID, i_ExportType);
                v_Xml.append(v_NewSpace).append(IToXml.toEnd("route"));
            }
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        if (!(!ExportType.UI.equals((Object)i_ExportType) || Help.isNull(this.route.getSucceeds()) && Help.isNull(this.route.getExceptions()))) {
            this.toXmlRouteItems(v_Xml, this.route.getSucceeds(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
            this.toXmlRouteItems(v_Xml, this.route.getExceptions(), ElementType.RouteItem.getXmlName(), i_Level - 2, v_TreeID, i_ExportType);
        }
        return v_Xml.toString();
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder;
        block43: {
            v_Builder = new StringBuilder();
            if (!Help.isNull((String)this.returnID)) {
                v_Builder.append(":").append(this.returnID).append(" = ");
            }
            if (!Help.isNull((String)this.cacheXID)) {
                v_Builder.append(this.getCacheXID());
                if (XJava.getObject((String)this.cacheXID) == null) {
                    v_Builder.append(" is NULL");
                }
            } else {
                v_Builder.append("?");
            }
            v_Builder.append(".");
            if (!Help.isNull((String)this.dataBase)) {
                String v_Database = null;
                try {
                    v_Database = (String)ValueHelp.getValue(this.dataBase, String.class, "", i_Context);
                }
                catch (Exception exce) {
                    $Logger.error(this.getXid() + ".Database[" + this.dataBase + "] is error", (Throwable)exce);
                }
                if (!Help.isNull((String)v_Database)) {
                    v_Builder.append(v_Database);
                } else {
                    v_Builder.append("[").append(this.dataBase).append("=?]");
                }
                v_Builder.append(".");
                if (!Help.isNull((String)this.table)) {
                    String v_Table = null;
                    try {
                        v_Table = (String)ValueHelp.getValue(this.table, String.class, "", i_Context);
                    }
                    catch (Exception exce) {
                        $Logger.error(this.getXid() + ".Table[" + this.table + "] is error", (Throwable)exce);
                    }
                    if (!Help.isNull((String)v_Table)) {
                        v_Builder.append(v_Table);
                    } else {
                        v_Builder.append("[").append(this.table).append("=?]");
                    }
                    v_Builder.append(".");
                    if (!Help.isNull((String)this.pkID)) {
                        String v_PKID = null;
                        try {
                            v_PKID = (String)ValueHelp.getValue(this.pkID, String.class, "", i_Context);
                        }
                        catch (Exception exce) {
                            $Logger.error(this.getXid() + ".PKID[" + this.pkID + "] is error", (Throwable)exce);
                        }
                        if (!Help.isNull((String)v_PKID)) {
                            v_Builder.append(v_PKID);
                            try {
                                Object v_RowData = this.gatRowData(i_Context);
                                if (v_RowData == null) {
                                    v_Builder.append("\u5220\u9664\u4e00\u884c\u6570\u636e");
                                    break block43;
                                }
                                if (v_RowData instanceof String) {
                                    String v_RowText = (String)v_RowData;
                                    if (Help.isNull((String)v_RowText)) {
                                        v_Builder.append("\u5220\u9664\u4e00\u884c\u6570\u636e");
                                    } else {
                                        v_Builder.append("=").append(v_RowText);
                                    }
                                    break block43;
                                }
                                v_Builder.append("=").append(v_RowData.toString());
                            }
                            catch (Exception exce) {
                                $Logger.error(this.getXid() + ".PKID[" + this.pkID + "] is error", (Throwable)exce);
                            }
                        } else {
                            v_Builder.append("[").append(this.pkID).append("=?]");
                        }
                    } else if (this.allowDelTable.booleanValue()) {
                        v_Builder.append("\u5220\u9664\u8868\u4e2d\u5168\u90e8\u6570\u636e");
                    } else {
                        v_Builder.append("Error");
                    }
                } else if (this.allowDelTable.booleanValue()) {
                    v_Builder.append("\u5220\u9664\u5e93\u4e2d\u5168\u90e8\u8868");
                } else {
                    v_Builder.append("Error");
                }
            } else if (!Help.isNull((String)this.pkID)) {
                String v_PKID = null;
                try {
                    v_PKID = (String)ValueHelp.getValue(this.pkID, String.class, "", i_Context);
                    if (!Help.isNull((String)v_PKID)) {
                        v_Builder.append(this.pkID);
                        Object v_RowData = this.gatRowData(i_Context);
                        if (v_RowData == null) {
                            v_Builder.append("\u5220\u9664Key");
                        } else if (v_RowData instanceof String) {
                            String v_RowText = (String)v_RowData;
                            if (Help.isNull((String)v_RowText)) {
                                v_Builder.append("\u5220\u9664Key");
                            } else {
                                v_Builder.append("=").append(v_RowText);
                            }
                        } else {
                            v_Builder.append("=").append(v_RowData.toString());
                        }
                        break block43;
                    }
                    v_Builder.append("[").append(this.pkID).append("=?]");
                }
                catch (Exception exce) {
                    $Logger.error(this.getXid() + ".PKID[" + this.pkID + "] is error", (Throwable)exce);
                }
            } else {
                v_Builder.append("?");
            }
        }
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.returnID)) {
            v_Builder.append(":").append(this.returnID).append(" = ");
        }
        if (!Help.isNull((String)this.cacheXID)) {
            v_Builder.append(this.getCacheXID());
            if (XJava.getObject((String)this.cacheXID) == null) {
                v_Builder.append(" is NULL");
            }
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(".");
        if (!Help.isNull((String)this.dataBase)) {
            v_Builder.append(this.dataBase);
            v_Builder.append(".");
            if (!Help.isNull((String)this.table)) {
                v_Builder.append(this.table);
                v_Builder.append(".");
                if (!Help.isNull((String)this.pkID)) {
                    v_Builder.append(this.pkID);
                    if (Help.isNull((String)this.rowData)) {
                        v_Builder.append("\u5220\u9664\u4e00\u884c\u6570\u636e");
                    } else {
                        v_Builder.append("=").append(this.rowData);
                    }
                } else if (this.allowDelTable.booleanValue()) {
                    v_Builder.append("\u5220\u9664\u8868\u4e2d\u5168\u90e8\u6570\u636e");
                } else {
                    v_Builder.append("Error");
                }
            } else if (this.allowDelTable.booleanValue()) {
                v_Builder.append("\u5220\u9664\u5e93\u4e2d\u5168\u90e8\u8868");
            } else {
                v_Builder.append("Error");
            }
        } else if (!Help.isNull((String)this.pkID)) {
            v_Builder.append(this.pkID);
            if (Help.isNull((String)this.rowData)) {
                v_Builder.append("\u5220\u9664Key");
            } else {
                v_Builder.append("=").append(this.rowData);
            }
        } else {
            v_Builder.append("?");
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new CacheSetConfig();
    }

    @Override
    public Object cloneMyOnly() {
        CacheSetConfig v_Clone = new CacheSetConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.cacheXID = this.cacheXID;
        v_Clone.dataBase = this.dataBase;
        v_Clone.table = this.table;
        v_Clone.pkID = this.pkID;
        v_Clone.nullDel = this.nullDel;
        v_Clone.expireTime = this.expireTime;
        v_Clone.allowDelTable = this.allowDelTable;
        v_Clone.setRowData(this.rowData);
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone CacheSetConfig xid is null.");
        }
        CacheSetConfig v_Clone = (CacheSetConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.cacheXID = this.cacheXID;
        v_Clone.dataBase = this.dataBase;
        v_Clone.table = this.table;
        v_Clone.pkID = this.pkID;
        v_Clone.nullDel = this.nullDel;
        v_Clone.expireTime = this.expireTime;
        v_Clone.allowDelTable = this.allowDelTable;
        v_Clone.setRowData(this.rowData);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone CacheSetConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        CacheSetConfig v_Clone = new CacheSetConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

