/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.cache;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.hy.common.callflow.cache.ICache;
import org.hy.common.redis.IRedis;

public class CacheRemote<Data>
implements ICache<Data> {
    private IRedis redis;
    private Class<Data> dataClass;

    public CacheRemote(IRedis i_Redis) {
        this.redis = i_Redis;
        this.dataClass = this.parserDataType();
    }

    public CacheRemote(IRedis i_Redis, Class<Data> i_DataClass) {
        this.redis = i_Redis;
        this.dataClass = i_DataClass;
    }

    private Class<Data> parserDataType() {
        ParameterizedType v_ParameterizedType;
        Type[] v_TypeArgs;
        Type v_SuperClass = this.getClass().getGenericSuperclass();
        if (v_SuperClass instanceof ParameterizedType && (v_TypeArgs = (v_ParameterizedType = (ParameterizedType)v_SuperClass).getActualTypeArguments()).length > 0 && v_TypeArgs[0] instanceof Class) {
            return (Class)v_TypeArgs[0];
        }
        return null;
    }

    @Override
    public Long save(String i_Database, String i_Table, String i_ID, Data i_Data) {
        return this.redis.save(i_Database, i_Table, i_ID, i_Data, true);
    }

    @Override
    public Long save(String i_Database, String i_Table, String i_ID, Data i_Data, long i_ExpireTime) {
        return this.redis.save(i_Database, i_Table, i_ID, i_Data, true, Long.valueOf(i_ExpireTime));
    }

    @Override
    public Long save(String i_Database, String i_Table, String i_ID, Map<String, Object> i_Datas, Long i_ExpireTime) {
        return this.redis.save(i_Database, i_Table, i_ID, i_Datas, i_ExpireTime);
    }

    @Override
    public Long save(String i_Database, String i_Table, String i_ID, Object i_Datas, boolean i_HaveNullValue, Long i_ExpireTime) {
        return this.redis.save(i_Database, i_Table, i_ID, i_Datas, i_HaveNullValue, i_ExpireTime);
    }

    @Override
    public synchronized Data remove(String i_Database, String i_Table, String i_ID) {
        Long v_Count;
        Object v_Old = this.redis.getRow(i_ID, this.dataClass);
        if (v_Old != null && ((v_Count = this.redis.delete(i_Database, i_Table, i_ID)) == null || v_Count <= 0L)) {
            return null;
        }
        return (Data)v_Old;
    }

    @Override
    public boolean dropTable(String i_Database, String i_Table) {
        return this.redis.dropTable(i_Database, i_Table);
    }

    @Override
    public boolean dropDatabase(String i_Database) {
        return this.redis.dropDatabase(i_Database);
    }

    @Override
    public Data get(String i_Database, String i_Table, String i_ID) {
        return (Data)this.redis.getRow(i_Database, i_Table, i_ID, this.dataClass);
    }

    @Override
    public Data getRow(String i_Database, String i_Table, String i_ID) {
        return (Data)this.redis.getRow(i_Database, i_Table, i_ID, this.dataClass);
    }

    @Override
    public Map<String, Data> getRowsMap(String i_Database, String i_Table) {
        return this.redis.getRows(i_Database, i_Table, this.dataClass);
    }

    @Override
    public List<Data> getRowsList(String i_Database, String i_Table) {
        return this.redis.getRowsList(i_Database, i_Table, this.dataClass);
    }

    @Override
    public Map<String, String> getRows(String i_Database) {
        return this.redis.getRows(i_Database);
    }

    @Override
    public Boolean set(String i_Key, String i_Value) {
        return this.redis.set(i_Key, i_Value);
    }

    @Override
    public Boolean setex(String i_Key, String i_Value, Long i_ExpireTime) {
        return this.redis.setex(i_Key, i_Value, i_ExpireTime);
    }

    @Override
    public Boolean setnx(String i_Key, String i_Value) {
        return this.redis.setnx(i_Key, i_Value);
    }

    @Override
    public String get(String i_Key) {
        return this.redis.get(i_Key);
    }

    @Override
    public String getdel(String i_Key) {
        return this.redis.getdel(i_Key);
    }

    @Override
    public Long del(String ... i_Keys) {
        return this.redis.del(i_Keys);
    }

    @Override
    public Long delete(String i_Database, String i_Table, String i_ID) {
        return this.redis.delete(i_Database, i_Table, i_ID);
    }
}

