/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.ifelse;

import java.util.Map;
import org.hy.common.Help;
import org.hy.common.StringHelp;
import org.hy.common.XJavaID;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.Comparer;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.ifelse.IfElse;
import org.hy.common.xml.log.Logger;

public class ConditionItem
implements IfElse,
XJavaID {
    private static final Logger $Logger = new Logger(ConditionItem.class);
    protected String id;
    protected String xid;
    protected String comment;
    protected Comparer comparer;
    protected String valueClass;
    protected String valueXIDA;
    protected String valueXIDB;

    public ConditionItem() {
        this(Comparer.Equal, null, null, null);
    }

    public ConditionItem(String i_ValueXIDA) {
        this(Comparer.Equal, null, i_ValueXIDA, null);
    }

    public ConditionItem(Comparer i_Comparer, String i_ValueXIDA, String i_ValueXIDB) {
        this(i_Comparer, null, i_ValueXIDA, i_ValueXIDB);
    }

    public ConditionItem(Comparer i_Comparer, String i_ValueClass, String i_ValueXIDA, String i_ValueXIDB) {
        this.comparer = i_Comparer;
        this.valueClass = i_ValueClass;
        this.valueXIDA = i_ValueXIDA;
        this.valueXIDB = i_ValueXIDB;
    }

    @Override
    public boolean allow(Map<String, Object> i_Context) throws Exception {
        if (this.comparer == null) {
            throw new NullPointerException("ConditionItem comparer [" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "] is null.");
        }
        if (this.valueXIDA == null) {
            throw new NullPointerException("ConditionItem valueA [" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "] is null.");
        }
        if (this.valueXIDB == null) {
            Object v_ValueA = ValueHelp.getValue(this.valueXIDA, this.gatValueClass(), null, i_Context);
            if (Comparer.Equal.equals((Object)this.comparer)) {
                if (v_ValueA == null) {
                    return true;
                }
                if (Boolean.class.equals(v_ValueA.getClass())) {
                    return (Boolean)v_ValueA;
                }
                return false;
            }
            if (Comparer.EqualNot.equals((Object)this.comparer)) {
                if (v_ValueA == null) {
                    return false;
                }
                if (Boolean.class.equals(v_ValueA.getClass())) {
                    return (Boolean)v_ValueA == false;
                }
                return true;
            }
            return v_ValueA != null;
        }
        Object v_ValueA = ValueHelp.getValue(this.valueXIDA, this.gatValueClass(), null, i_Context);
        Object v_ValueB = ValueHelp.getValue(this.valueXIDB, this.gatValueClass(), null, i_Context);
        return this.comparer.compare(v_ValueA, v_ValueB);
    }

    @Override
    public boolean reject(Map<String, Object> i_Context) throws Exception {
        return !this.allow(i_Context);
    }

    public Comparer getComparer() {
        return this.comparer;
    }

    public void setComparer(Comparer i_Comparer) {
        this.comparer = i_Comparer;
    }

    public Class<?> gatValueClass() {
        if (!Help.isNull((String)this.valueClass)) {
            try {
                return Help.forName((String)this.valueClass);
            }
            catch (Exception exce) {
                throw new RuntimeException(exce);
            }
        }
        return null;
    }

    public String getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(String i_ValueClass) {
        this.valueClass = i_ValueClass;
    }

    public String getValueXIDA() {
        return this.valueXIDA;
    }

    public void setValueXIDA(String i_ValueXIDA) {
        if (CallFlow.isSystemXID(i_ValueXIDA)) {
            throw new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s ValueXIDA[" + i_ValueXIDA + "] is SystemXID.");
        }
        this.valueXIDA = i_ValueXIDA;
    }

    public String getValueXIDB() {
        return this.valueXIDB;
    }

    public void setValueXIDB(String i_ValueXIDB) {
        if (CallFlow.isSystemXID(i_ValueXIDB)) {
            throw new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s ValueXIDB[" + i_ValueXIDB + "] is SystemXID.");
        }
        this.valueXIDB = i_ValueXIDB;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String i_Id) {
        this.id = i_Id;
    }

    public String getXid() {
        return this.xid;
    }

    public void setXid(String i_Xid) {
        this.xid = i_Xid;
    }

    public void setXJavaID(String i_XJavaID) {
        this.xid = i_XJavaID;
    }

    public String getXJavaID() {
        return this.xid;
    }

    public void setComment(String i_Comment) {
        this.comment = i_Comment;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID) {
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = "conditionItem";
        if (!Help.isNull((String)this.getXJavaID())) {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        if (!Help.isNull((String)this.comment)) {
            v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(IToXml.toValue("comment", this.comment));
        }
        if (this.valueClass != null) {
            v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(IToXml.toValue("valueClass", this.gatValueClass().getName()));
        }
        if (!Help.isNull((String)this.valueXIDA)) {
            v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(IToXml.toValue("valueXIDA", this.valueXIDA));
        }
        if (this.comparer != null && Comparer.Equal != this.comparer) {
            v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(IToXml.toValue("comparer", this.comparer.getValue()));
        }
        if (!Help.isNull((String)this.valueXIDB)) {
            v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(IToXml.toValue("valueXIDB", this.valueXIDB));
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        return v_Xml.toString();
    }

    @Override
    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        if (this.comparer != null) {
            Object v_ValueA = null;
            Object v_ValueB = null;
            Class<?> v_VClass = null;
            try {
                v_VClass = this.gatValueClass();
                v_ValueA = ValueHelp.getValue(this.valueXIDA, v_VClass, null, i_Context);
            }
            catch (Exception exce) {
                $Logger.error("ConditionItem[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s valueXIDA[" + this.valueXIDA + "] getValue error.", (Throwable)exce);
                v_ValueA = "ERROR";
            }
            if (this.valueXIDB == null) {
                v_Builder.append(this.valueXIDA).append("[");
                v_Builder.append(ValueHelp.getExpression(v_ValueA));
                v_Builder.append("] ");
                if (Comparer.Equal.equals((Object)this.comparer)) {
                    v_Builder.append(this.comparer.getValue());
                    if (Boolean.class.equals(v_VClass)) {
                        v_Builder.append(" TRUE");
                    } else if (v_ValueA == null) {
                        v_Builder.append(" NULL");
                    } else {
                        v_Builder.append(" NULL");
                    }
                } else if (Comparer.EqualNot.equals((Object)this.comparer)) {
                    v_Builder.append(this.comparer.getValue());
                    if (Boolean.class.equals(v_VClass)) {
                        v_Builder.append(" TRUE");
                    } else if (v_ValueA == null) {
                        v_Builder.append(" NULL");
                    } else {
                        v_Builder.append(" NULL");
                    }
                } else {
                    v_Builder.append("!= NULL");
                }
            } else {
                try {
                    v_ValueB = ValueHelp.getValue(this.valueXIDB, v_VClass, null, i_Context);
                }
                catch (Exception exce) {
                    $Logger.error("ConditionItem[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s valueXIDB[" + this.valueXIDB + "] getValue error.", (Throwable)exce);
                    v_ValueB = "ERROR";
                }
                v_Builder.append(ValueHelp.getExpression(v_ValueA));
                v_Builder.append(" ").append(this.comparer.getValue()).append(" ");
                v_Builder.append(ValueHelp.getExpression(v_ValueB));
            }
        }
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (this.comparer != null) {
            v_Builder.append(this.valueXIDA == null ? "NULL" : ValueHelp.getExpression(this.valueXIDA, this.gatValueClass()));
            v_Builder.append(" ").append(this.comparer.getValue()).append(" ");
            v_Builder.append(this.valueXIDA == null ? "NULL" : ValueHelp.getExpression(this.valueXIDB, this.gatValueClass()));
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new ConditionItem();
    }

    @Override
    public Object cloneMyOnly() {
        ConditionItem v_Clone = new ConditionItem();
        v_Clone.id = this.id;
        v_Clone.comment = this.comment;
        v_Clone.comparer = this.comparer;
        v_Clone.valueClass = this.valueClass;
        v_Clone.valueXIDA = this.valueXIDA;
        v_Clone.valueXIDB = this.valueXIDB;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        ConditionItem v_Clone = (ConditionItem)io_Clone;
        v_Clone.xid = this.cloneXID(this.xid, i_ReplaceXID, i_ReplaceByXID, i_AppendXID);
        v_Clone.id = this.id;
        v_Clone.comment = this.comment;
        v_Clone.comparer = this.comparer;
        v_Clone.valueClass = this.valueClass;
        v_Clone.valueXIDA = this.valueXIDA;
        v_Clone.valueXIDB = this.valueXIDB;
    }
}

