/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.node;

import java.awt.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.MethodReflect;
import org.hy.common.Return;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.XSQLType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.node.NodeConfig;
import org.hy.common.callflow.node.NodeConfigBase;
import org.hy.common.callflow.node.NodeParam;
import org.hy.common.xml.XJava;
import org.hy.common.xml.XSQL;
import org.hy.common.xml.XSQLData;
import org.hy.common.xml.plugins.XSQLGroup;
import org.hy.common.xml.plugins.XSQLGroupResult;

public class XSQLConfig
extends NodeConfig
implements NodeConfigBase {
    private XSQLType type = XSQLType.Auto;

    public XSQLConfig() {
        this(0L, 0L);
    }

    public XSQLConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    public XSQLType getType() {
        return this.type;
    }

    public void setType(XSQLType i_Type) {
        this.type = i_Type == null ? XSQLType.Auto : i_Type;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initCallMethod(Object i_ExecuteObject) {
        XSQLType v_XSQLType = this.type;
        if (XSQLType.Auto.equals((Object)v_XSQLType)) {
            if (Help.isNull((String)this.getCallXID())) {
                throw new RuntimeException("CallXID is null");
            }
            if (i_ExecuteObject == null) {
                throw new RuntimeException("CallXID is not find");
            }
            if (i_ExecuteObject instanceof XSQL) {
                v_XSQLType = this.parserXSQLType((XSQL)i_ExecuteObject);
            } else {
                if (!(i_ExecuteObject instanceof XSQLGroup)) throw new RuntimeException("Unknown type\uff1a" + i_ExecuteObject.getClass().getName());
                v_XSQLType = XSQLType.XSQLGroup;
            }
        }
        if (XSQLType.XSQLGroup.equals((Object)v_XSQLType)) {
            this.setCallMethod("executes");
            return;
        } else if (XSQLType.Create.equals((Object)v_XSQLType)) {
            this.setCallMethod("executeInsertPrepared");
            if (Help.isNull(this.getCallParams())) return;
            String v_ValueClass = this.getCallParams().get(0).getValueClass();
            try {
                Class v_VClass = Help.forName((String)v_ValueClass);
                if (!MethodReflect.isExtendImplement((Class)v_VClass, List.class)) return;
                this.setCallMethod("executeInsertsPrepared");
                return;
            }
            catch (Exception exce) {
                throw new RuntimeException(exce);
            }
        } else if (XSQLType.Read.equals((Object)v_XSQLType)) {
            this.setCallMethod("queryXSQLData");
            return;
        } else if (XSQLType.Update.equals((Object)v_XSQLType) || XSQLType.Delete.equals((Object)v_XSQLType)) {
            this.setCallMethod("executeUpdatePrepared");
            if (Help.isNull(this.getCallParams())) return;
            String v_ValueClass = this.getCallParams().get(0).getValueClass();
            try {
                Class v_VClass = Help.forName((String)v_ValueClass);
                if (!MethodReflect.isExtendImplement((Class)v_VClass, List.class)) return;
                this.setCallMethod("executeUpdatesPrepared");
                return;
            }
            catch (Exception exce) {
                throw new RuntimeException(exce);
            }
        } else {
            this.setCallMethod("execute");
        }
    }

    private XSQLType parserXSQLType(XSQL i_XSQL) {
        int v_SQLType = i_XSQL.getContent().getSQLType();
        if (2 == v_SQLType) {
            return XSQLType.Create;
        }
        if (1 == v_SQLType) {
            return XSQLType.Read;
        }
        if (3 == v_SQLType) {
            return XSQLType.Update;
        }
        if (4 == v_SQLType) {
            return XSQLType.Delete;
        }
        if (6 == v_SQLType) {
            return XSQLType.DDL;
        }
        throw new RuntimeException("Unknown SQL type\uff1a" + v_SQLType);
    }

    @Override
    public String getElementType() {
        return ElementType.XSQL.getValue();
    }

    @Override
    public String toXmlName() {
        return ElementType.XSQL.getXmlName();
    }

    @Override
    public Object generateObject(Map<String, Object> io_Context, Object io_ExecuteObject) {
        this.initCallMethod(io_ExecuteObject);
        return io_ExecuteObject;
    }

    @Override
    public Return<Object> generateReturn(Map<String, Object> io_Context, Object io_ExecuteReturn) {
        if (io_ExecuteReturn instanceof XSQLData) {
            return new Return(true).setParamObj(((XSQLData)io_ExecuteReturn).getDatas());
        }
        if (io_ExecuteReturn instanceof XSQLGroupResult) {
            XSQLGroupResult v_XSQLGRet = (XSQLGroupResult)io_ExecuteReturn;
            if (v_XSQLGRet.isSuccess()) {
                return new Return(true).setParamObj((Object)v_XSQLGRet.getReturns());
            }
            return new Return(false).setException(v_XSQLGRet.getException());
        }
        return new Return(true).setParamObj(io_ExecuteReturn);
    }

    @Override
    public void toXmlContent(StringBuilder io_Xml, int i_Level, String i_Level1, String i_LevelN, String i_SuperTreeID, String i_TreeID) {
        if (this.type != null) {
            io_Xml.append("\n").append(i_LevelN).append(i_Level1).append(IToXml.toValue("type", this.type.getValue()));
        }
        if (!Help.isNull((String)this.getCallXID())) {
            io_Xml.append("\n").append(i_LevelN).append(i_Level1).append(IToXml.toValue("callXID", this.getCallXID()));
        }
        if (!Help.isNull(this.getCallParams())) {
            for (NodeParam v_Param : this.getCallParams()) {
                io_Xml.append(v_Param.toXml(i_Level + 1, i_TreeID));
            }
        }
    }

    @Override
    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.returnID)) {
            v_Builder.append(":").append(this.returnID).append(" = ");
        }
        v_Builder.append(":");
        if (!Help.isNull((String)this.callXID)) {
            v_Builder.append(this.callXID);
            if (XJava.getObject((String)this.callXID) == null) {
                v_Builder.append(" is NULL");
            }
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(".");
        if (Help.isNull((String)this.callMethod)) {
            this.initCallMethod(XJava.getObject((String)this.callXID));
        }
        if (!Help.isNull((String)this.callMethod)) {
            v_Builder.append(this.callMethod);
            this.init(i_Context);
            if (this.callMethodObject == null) {
                v_Builder.append(" not find");
            }
        } else {
            v_Builder.append("?");
        }
        v_Builder.append("(");
        if (!Help.isNull((java.util.List)this.callParams)) {
            for (int x = 0; x < this.callParams.size(); ++x) {
                if (x >= 1) {
                    v_Builder.append(" ,");
                }
                v_Builder.append(((NodeParam)this.callParams.get(x)).toString(i_Context));
            }
        }
        v_Builder.append(")");
        return v_Builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.returnID)) {
            v_Builder.append(":").append(this.returnID).append(" = ");
        }
        v_Builder.append(":");
        if (!Help.isNull((String)this.callXID)) {
            v_Builder.append(this.callXID);
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(".");
        if (Help.isNull((String)this.callMethod)) {
            try {
                this.initCallMethod(XJava.getObject((String)this.callXID));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!Help.isNull((String)this.callMethod)) {
            v_Builder.append(this.callMethod);
        } else {
            v_Builder.append("?");
        }
        v_Builder.append("(");
        if (!Help.isNull((java.util.List)this.callParams)) {
            for (int x = 0; x < this.callParams.size(); ++x) {
                if (x >= 1) {
                    v_Builder.append(" ,");
                }
                v_Builder.append(((NodeParam)this.callParams.get(x)).toString());
            }
        }
        v_Builder.append(")");
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new XSQLConfig();
    }

    @Override
    public Object cloneMyOnly() {
        XSQLConfig v_Clone = new XSQLConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.setCallXID(this.getCallXID());
        if (!Help.isNull(this.getCallParams())) {
            v_Clone.setCallParams(new ArrayList<NodeParam>());
            for (NodeParam v_NodeParam : this.getCallParams()) {
                v_Clone.getCallParams().add((NodeParam)v_NodeParam.cloneMyOnly());
            }
        }
        v_Clone.setTimeout(this.getTimeout());
        v_Clone.setContext(this.getContext());
        v_Clone.type = this.type;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone XSQLConfig xid is null.");
        }
        XSQLConfig v_Clone = (XSQLConfig)io_Clone;
        ((ExecuteElement)this).clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.setCallXID(this.getCallXID());
        if (!Help.isNull(this.getCallParams())) {
            v_Clone.setCallParams(new ArrayList<NodeParam>());
            for (NodeParam v_NodeParam : this.getCallParams()) {
                v_Clone.getCallParams().add((NodeParam)v_NodeParam.cloneMyOnly());
            }
        }
        v_Clone.setTimeout(this.getTimeout());
        v_Clone.setContext(this.getContext());
        v_Clone.type = this.type;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone XSQLConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        XSQLConfig v_Clone = new XSQLConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

