/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.node;

import java.util.Map;
import org.hy.common.Help;
import org.hy.common.StringHelp;
import org.hy.common.XJavaID;
import org.hy.common.callflow.clone.CloneableCallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.xml.XJSON;
import org.hy.common.xml.log.Logger;

public class NodeParam
implements IToXml,
CloneableCallFlow,
XJavaID {
    private static final Logger $Logger = new Logger(NodeParam.class);
    private String id;
    private String xid;
    private String comment;
    private String valueClass;
    private String value;
    private String valueDefault;
    private Object valueDefaultObject;

    public NodeParam() {
    }

    public NodeParam(String i_Value) {
        this(i_Value, null);
    }

    public NodeParam(String i_Value, String i_ValueClass) {
        if (Help.isNull((String)i_Value)) {
            throw new NullPointerException("NodeParam's value is null.");
        }
        if (!i_Value.startsWith(":") && i_ValueClass == null) {
            throw new NullPointerException("NodeParam's valueClass is null, but value is not Placeholder.");
        }
        this.setValue(i_Value);
        this.setValueClass(i_ValueClass);
    }

    public NodeParam(String i_Value, String i_ValueClass, String i_ValueDefault) {
        if (Help.isNull((String)i_Value)) {
            throw new NullPointerException("NodeParam's value is null.");
        }
        if (!i_Value.startsWith(":")) {
            if (i_ValueClass == null) {
                throw new NullPointerException("NodeParam's valueClass is null, but value is not Placeholder.");
            }
        } else if (i_ValueDefault != null && i_ValueClass == null) {
            throw new NullPointerException("NodeParam's value is Placeholder and valueClass is null, but valueDefault is not null.");
        }
        this.setValue(i_Value);
        this.setValueClass(i_ValueClass);
        this.setValueDefault(i_ValueDefault);
    }

    public synchronized Object gatValueDefaultObject() throws Exception {
        if (this.valueDefault == null || this.valueClass == null) {
            return null;
        }
        if (this.valueDefaultObject == null) {
            Class<?> v_ValueClass = this.gatValueClass();
            if (Help.isBasicDataType(v_ValueClass)) {
                this.valueDefaultObject = Help.toObject(v_ValueClass, (String)this.valueDefault);
            } else {
                XJSON v_XJson = new XJSON();
                this.valueDefaultObject = v_XJson.toJava(this.valueDefault, v_ValueClass);
            }
        }
        return this.valueDefaultObject;
    }

    public Class<?> gatValueClass() {
        if (!Help.isNull((String)this.valueClass)) {
            try {
                return Help.forName((String)this.valueClass);
            }
            catch (Exception exce) {
                throw new RuntimeException(exce);
            }
        }
        return null;
    }

    public String getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(String i_ValueClass) {
        this.valueClass = Help.isNull((String)i_ValueClass) || Void.class.getName().equals(i_ValueClass) ? null : i_ValueClass;
        this.valueDefaultObject = null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String i_Value) {
        this.value = i_Value;
    }

    public String getValueDefault() {
        return this.valueDefault;
    }

    public void setValueDefault(String i_ValueDefault) {
        this.valueDefault = i_ValueDefault;
        this.valueDefaultObject = null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String i_Id) {
        this.id = i_Id;
    }

    public String getXid() {
        return this.xid;
    }

    public void setXid(String i_Xid) {
        this.xid = i_Xid;
    }

    public void setXJavaID(String i_XJavaID) {
        this.xid = i_XJavaID;
    }

    public String getXJavaID() {
        return this.xid;
    }

    public void setComment(String i_Comment) {
        this.comment = i_Comment;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID) {
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = "callParam";
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        if (!Help.isNull((String)this.comment)) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("comment", this.comment));
        }
        if (this.valueClass != null) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("valueClass", this.gatValueClass().getName()));
        }
        if (!Help.isNull((String)this.value)) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("value", this.value, v_NewSpace));
        }
        if (!Help.isNull((String)this.valueDefault)) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("valueDefault", this.valueDefault, v_NewSpace));
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        return v_Xml.toString();
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        Object v_Value = null;
        try {
            v_Value = ValueHelp.getValue(this.value, this.gatValueClass(), this.gatValueDefaultObject(), i_Context);
        }
        catch (Exception exce) {
            $Logger.error("NodeParam[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s value[" + this.value + "] getValue error.", (Throwable)exce);
        }
        v_Builder.append(ValueHelp.getExpression(v_Value));
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (this.value == null) {
            v_Builder.append("NULL");
        } else if (this.value.startsWith(":")) {
            v_Builder.append(this.value);
            if (this.valueDefault != null) {
                v_Builder.append(" default");
            }
        } else if (this.valueClass != null) {
            v_Builder.append(ValueHelp.getExpression(this.value, this.gatValueClass()));
        } else {
            v_Builder.append(this.value).append("::?");
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new NodeParam();
    }

    @Override
    public Object cloneMyOnly() {
        NodeParam v_Clone = new NodeParam();
        v_Clone.id = this.id;
        v_Clone.comment = this.comment;
        v_Clone.valueClass = this.valueClass;
        v_Clone.value = this.value;
        v_Clone.valueDefault = this.valueDefault;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        NodeParam v_Clone = (NodeParam)io_Clone;
        v_Clone.xid = this.cloneXID(this.xid, i_ReplaceXID, i_ReplaceByXID, i_AppendXID);
        v_Clone.id = this.id;
        v_Clone.comment = this.comment;
        v_Clone.valueClass = this.valueClass;
        v_Clone.value = this.value;
        v_Clone.valueDefault = this.valueDefault;
    }
}

