/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.node;

import java.util.HashMap;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.node.APIException;
import org.hy.common.callflow.node.NodeConfig;
import org.hy.common.callflow.node.NodeConfigBase;
import org.hy.common.callflow.node.NodeParam;
import org.hy.common.xml.XHttp;
import org.hy.common.xml.XJSON;
import org.hy.common.xml.XJava;

public class APIConfig
extends NodeConfig
implements NodeConfigBase {
    protected String url;
    protected String param;
    protected String body;
    protected String head;
    protected String returnClass;
    protected String returnClassKey;
    protected String succeedFlag;
    private XHttp callObject;

    public APIConfig() {
        this(0L, 0L);
    }

    public APIConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
        String v_XHttpXID = "XAPI" + StringHelp.getUUID9n();
        this.callObject = new XHttp();
        this.callObject.setXJavaID(v_XHttpXID);
        this.callObject.setContentType("application/json");
        this.callObject.setEncode(false);
        this.callObject.setToUnicode(false);
        this.callObject.setRequestType(1);
        this.callObject.setHaveQuestionMark(false);
        XJava.putObject((String)v_XHttpXID, (Object)this.callObject);
        this.setCallXID(v_XHttpXID);
        this.setCallMethod("request");
        NodeParam v_CallParam = new NodeParam();
        v_CallParam.setValueClass(String.class.getName());
        v_CallParam.setValue("");
        this.setCallParam(v_CallParam);
        v_CallParam = new NodeParam();
        v_CallParam.setValueClass(String.class.getName());
        v_CallParam.setValue("");
        this.setCallParam(v_CallParam);
        v_CallParam = new NodeParam();
        v_CallParam.setValueClass(Map.class.getName());
        v_CallParam.setValue("{}");
        this.setCallParam(v_CallParam);
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setUrl(String i_Url) {
        Object[] v_HttpArr;
        if (Help.isNull((String)i_Url)) {
            this.callObject.setProtocol("http");
            this.callObject.setIp("127.0.0.1");
            this.callObject.setPort(80);
            this.callObject.setUrl(null);
        }
        if (Help.isNull((Object[])(v_HttpArr = i_Url.split("://"))) || v_HttpArr.length < 2) {
            throw new IllegalArgumentException("Url[" + i_Url + "] not find http:// or https://");
        }
        this.callObject.setProtocol(((String)v_HttpArr[0]).toLowerCase());
        Object[] v_ServiceNameArr = ((String)v_HttpArr[1]).split("/");
        if (Help.isNull((Object[])v_ServiceNameArr) || v_ServiceNameArr.length < 2) {
            this.callObject.setUrl("/");
        } else {
            this.callObject.setUrl(((String)v_HttpArr[1]).substring(((String)v_ServiceNameArr[0]).length()));
        }
        Object[] v_IPPortArr = ((String)v_ServiceNameArr[0]).split(":");
        if (Help.isNull((Object[])v_IPPortArr)) {
            if ("https".equals(this.callObject.getProtocol())) {
                this.callObject.setPort(443);
            } else {
                if (!"http".equals(this.callObject.getProtocol())) throw new IllegalArgumentException("Url[" + i_Url + "] not find Port");
                this.callObject.setPort(80);
            }
        } else if (v_IPPortArr.length < 2) {
            this.callObject.setIp((String)v_IPPortArr[0]);
        } else {
            if (v_IPPortArr.length != 2) throw new IllegalArgumentException("Url[" + i_Url + "] is error, more : in Url");
            if (!Help.isNumber((String)v_IPPortArr[1])) throw new IllegalArgumentException("Url[" + i_Url + "] port is not number");
            this.callObject.setIp((String)v_IPPortArr[0]);
            this.callObject.setPort(Integer.parseInt((String)v_IPPortArr[1]));
            if (this.callObject.getPort() <= 0) {
                throw new IllegalArgumentException("Url[" + i_Url + "] port is not 1~65535");
            }
        }
        this.url = i_Url;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getRequestType() {
        if (this.callObject.getRequestType() == 1) {
            return "GET";
        }
        if (this.callObject.getRequestType() == 2) {
            return "POST";
        }
        return "" + this.callObject.getRequestType();
    }

    public void setRequestType(String i_RequestType) {
        if (Help.isNull((String)i_RequestType)) {
            this.callObject.setRequestType(1);
        } else if (i_RequestType.trim().equalsIgnoreCase("POST")) {
            this.callObject.setRequestType(2);
        } else {
            this.callObject.setRequestType(1);
        }
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getContentType() {
        return this.callObject.getContentType();
    }

    public void setContentType(String i_ContentType) {
        this.callObject.setContentType(i_ContentType);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public int getConnectTimeout() {
        return this.callObject.getConnectTimeout();
    }

    public void setConnectTimeout(int i_ConnectTimeout) {
        this.callObject.setConnectTimeout(i_ConnectTimeout);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public int getReadTimeout() {
        return this.callObject.getReadTimeout();
    }

    public void setReadTimeout(int i_ReadTimeout) {
        this.callObject.setReadTimeout(i_ReadTimeout);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String i_Param) {
        this.param = i_Param;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String i_Body) {
        this.body = i_Body;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getHead() {
        return this.head;
    }

    public void setHead(String i_Head) {
        this.head = i_Head;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public Class<?> gatReturnClass() {
        if (!Help.isNull((String)this.returnClass)) {
            try {
                return Help.forName((String)this.returnClass);
            }
            catch (Exception exce) {
                throw new RuntimeException(exce);
            }
        }
        return null;
    }

    public String getReturnClass() {
        return this.returnClass;
    }

    public void setReturnClass(String i_ReturnClass) {
        this.returnClass = Void.class.getName().equals(i_ReturnClass) ? null : i_ReturnClass;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getReturnClassKey() {
        return this.returnClassKey;
    }

    public void setReturnClassKey(String i_ReturnClassKey) {
        this.returnClassKey = i_ReturnClassKey;
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getSucceedFlag() {
        return this.succeedFlag;
    }

    public void setSucceedFlag(String i_SucceedFlag) {
        this.succeedFlag = Help.isNull((String)i_SucceedFlag) ? null : i_SucceedFlag;
    }

    @Override
    public String getElementType() {
        return ElementType.Api.getValue();
    }

    @Override
    public String toXmlName() {
        return ElementType.Api.getXmlName();
    }

    @Override
    public Object[] generateParams(Map<String, Object> io_Context, Object[] io_Params) {
        if (!Help.isNull((String)this.param)) {
            io_Params[0] = ValueHelp.replaceByContext(this.param, io_Context);
        }
        if (!Help.isNull((String)this.body)) {
            io_Params[1] = ValueHelp.replaceByContext(this.body, io_Context);
        }
        if (!Help.isNull((String)this.head)) {
            String v_Head = ValueHelp.replaceByContext(this.head, io_Context);
            try {
                io_Params[2] = ValueHelp.getValue(v_Head, Map.class, null, io_Context);
            }
            catch (Exception exce) {
                throw new RuntimeException(exce);
            }
        }
        return io_Params;
    }

    @Override
    public Return<Object> generateReturn(Map<String, Object> io_Context, Object io_ExecuteReturn) {
        Return v_XHttpRet = (Return)io_ExecuteReturn;
        if (v_XHttpRet.get()) {
            Object v_ReturnValue = v_XHttpRet.getParamStr();
            if (!Help.isNull((String)this.returnClass)) {
                Class<?> v_ReturnClass = this.gatReturnClass();
                if (Help.isBasicDataType(v_ReturnClass)) {
                    v_ReturnValue = Help.toObject(v_ReturnClass, (String)v_ReturnValue.toString());
                } else {
                    XJSON v_XJson = new XJSON();
                    try {
                        v_ReturnValue = Help.isNull((String)this.returnClassKey) ? v_XJson.toJava(v_ReturnValue.toString(), v_ReturnClass) : v_XJson.toJava(v_ReturnValue.toString(), this.returnClassKey, v_ReturnClass);
                    }
                    catch (Exception exce) {
                        APIException v_Exce = new APIException(v_XHttpRet.getParamObj() == null ? "" : v_XHttpRet.getParamObj().toString(), v_XHttpRet.getParamStr(), exce);
                        return new Return(false).setException((Exception)v_Exce);
                    }
                }
            }
            if (!Help.isNull((String)this.succeedFlag)) {
                if (v_XHttpRet.getParamStr().indexOf(this.succeedFlag) >= 0) {
                    return new Return(true).setParamObj(v_ReturnValue);
                }
                APIException v_Exce = new APIException(v_XHttpRet.getParamObj() == null ? "" : v_XHttpRet.getParamObj().toString(), v_XHttpRet.getParamStr(), v_ReturnValue);
                return new Return(false).setException((Exception)v_Exce);
            }
            return new Return(true).setParamObj(v_ReturnValue);
        }
        APIException v_Exce = new APIException(v_XHttpRet.getParamObj() == null ? "" : v_XHttpRet.getParamObj().toString(), v_XHttpRet.getException().toString(), v_XHttpRet.getException());
        return new Return(false).setException((Exception)v_Exce);
    }

    @Override
    public void toXmlContent(StringBuilder io_Xml, int i_Level, String i_Level1, String i_LevelN, String i_SuperTreeID, String i_TreeID) {
        String v_NewSpace = "\n" + i_LevelN + i_Level1;
        if (!Help.isNull((String)this.url)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("url", this.url));
        }
        if (!Help.isNull((String)this.param)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("param", this.param));
        }
        if (!Help.isNull((String)this.body)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("body", this.body, v_NewSpace));
        }
        if (!Help.isNull((String)this.head)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("head", this.head));
        }
        if (!Help.isNull((String)this.getRequestType()) && this.callObject.getRequestType() != 1) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("requestType", this.getRequestType()));
        }
        if (!Help.isNull((String)this.getContentType()) && !"application/json".equalsIgnoreCase(this.getContentType())) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("contentType", this.getContentType()));
        }
        if (this.getConnectTimeout() != 30000) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("connectTimeout", this.getConnectTimeout()));
        }
        if (this.getReadTimeout() != 300000) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("readTimeout", this.getReadTimeout()));
        }
        if (!Help.isNull((String)this.returnClass)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("returnClass", this.returnClass));
        }
        if (!Help.isNull((String)this.returnClassKey)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("returnClassKey", this.returnClassKey));
        }
        if (!Help.isNull((String)this.succeedFlag)) {
            io_Xml.append(v_NewSpace).append(IToXml.toValue("succeedFlag", this.succeedFlag));
        }
    }

    @Override
    public String toString(Map<String, Object> i_Context) {
        return this.callObject.toString();
    }

    @Override
    public String toString() {
        return this.callObject.toString();
    }

    @Override
    public Object newMy() {
        return new APIConfig();
    }

    @Override
    public Object cloneMyOnly() {
        APIConfig v_Clone = new APIConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.setContext(this.getContext());
        v_Clone.setContentType(this.getContentType());
        v_Clone.setUrl(this.getUrl());
        v_Clone.setParam(this.getParam());
        v_Clone.setBody(this.getBody());
        v_Clone.setHead(this.getHead());
        v_Clone.setRequestType(this.getRequestType());
        v_Clone.setConnectTimeout(this.getConnectTimeout());
        v_Clone.setReadTimeout(this.getReadTimeout());
        v_Clone.setTimeout(this.getTimeout());
        v_Clone.setReturnClass(this.getReturnClass());
        v_Clone.setReturnClassKey(this.getReturnClassKey());
        v_Clone.setSucceedFlag(this.getSucceedFlag());
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone APIConfig xid is null.");
        }
        APIConfig v_Clone = (APIConfig)io_Clone;
        ((ExecuteElement)this).clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.setContext(this.getContext());
        v_Clone.setContentType(this.getContentType());
        v_Clone.setUrl(this.getUrl());
        v_Clone.setParam(this.getParam());
        v_Clone.setBody(this.getBody());
        v_Clone.setHead(this.getHead());
        v_Clone.setRequestType(this.getRequestType());
        v_Clone.setConnectTimeout(this.getConnectTimeout());
        v_Clone.setReadTimeout(this.getReadTimeout());
        v_Clone.setTimeout(this.getTimeout());
        v_Clone.setReturnClass(this.getReturnClass());
        v_Clone.setReturnClassKey(this.getReturnClassKey());
        v_Clone.setSucceedFlag(this.getSucceedFlag());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone APIConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        APIConfig v_Clone = new APIConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

