/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.nesting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.MethodReflect;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.nesting.MTExecuteResult;
import org.hy.common.callflow.nesting.MTItem;
import org.hy.common.callflow.route.RouteItem;
import org.hy.common.callflow.timeout.TimeoutConfig;
import org.hy.common.xml.XJava;
import org.hy.common.xml.log.Logger;

public class MTConfig
extends ExecuteElement
implements Cloneable {
    private static final Logger $Logger = new Logger(MTConfig.class);
    private List<MTItem> mtitems = new ArrayList<MTItem>();
    private Boolean oneByOne = false;
    private String waitTime = "0";
    private String context;

    public MTConfig() {
        this(0L, 0L);
    }

    public MTConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    @Override
    public String getElementType() {
        return ElementType.MT.getValue();
    }

    public MTItem getItem() {
        return new MTItem();
    }

    public void setItem(MTItem i_MTItem) {
        this.mtitems.add(i_MTItem);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public List<MTItem> getMtitems() {
        return this.mtitems;
    }

    public Boolean getOneByOne() {
        return this.oneByOne;
    }

    public void setOneByOne(Boolean i_OneByOne) {
        this.oneByOne = i_OneByOne == null ? Boolean.valueOf(false) : i_OneByOne;
    }

    public String getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(String i_WaitTime) {
        if (Help.isNull((String)i_WaitTime)) {
            NullPointerException v_Exce = new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s WaitTime is null.");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        if (Help.isNumber((String)i_WaitTime)) {
            Long v_WaitTime = Long.valueOf(i_WaitTime);
            if (v_WaitTime < 0L) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s WaitTime Less than zero.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
            this.waitTime = i_WaitTime.trim();
        } else {
            this.waitTime = ValueHelp.standardRefID(i_WaitTime);
        }
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public void setMtitems(List<MTItem> i_Mtitems) {
        if (i_Mtitems == null) {
            this.mtitems.clear();
        } else {
            this.mtitems = i_Mtitems;
        }
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String i_Context) {
        this.context = i_Context;
    }

    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        long v_BeginTime = this.request();
        ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context));
        this.refreshStatus(io_Context, v_Result.getStatus());
        try {
            ArrayList<MTExecuteResult> v_MTItemResults = new ArrayList<MTExecuteResult>();
            boolean v_IsOrderBy = false;
            Exception v_Exception = null;
            if (!Help.isNull((String)this.context)) {
                String v_Context = ValueHelp.replaceByContext(this.context, io_Context);
                Map v_ContextMap = (Map)ValueHelp.getValue(v_Context, Map.class, null, io_Context);
                io_Context.putAll(v_ContextMap);
                v_ContextMap.clear();
                v_ContextMap = null;
            }
            if (!Help.isNull(this.mtitems)) {
                for (int x = 0; x < this.mtitems.size(); ++x) {
                    MTItem v_Item = this.mtitems.get(x);
                    if (!Help.isNull((String)v_Item.getValueXIDA()) && v_Item.getComparer() != null && !v_Item.allow(io_Context)) continue;
                    if (Help.isNull((String)v_Item.gatCallFlowXID())) {
                        v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallFlowXID is null."));
                        this.refreshStatus(io_Context, v_Result.getStatus());
                        return v_Result;
                    }
                    Object v_CallObject = XJava.getObject((String)v_Item.gatCallFlowXID());
                    if (v_CallObject == null) {
                        v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallFlowXID[" + v_Item.gatCallFlowXID() + "] is not find."));
                        this.refreshStatus(io_Context, v_Result.getStatus());
                        return v_Result;
                    }
                    if (!MethodReflect.isExtendImplement((Object)v_CallObject, ExecuteElement.class)) {
                        v_Result.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallFlowXID[" + v_Item.gatCallFlowXID() + "] is not ExecuteElement."));
                        this.refreshStatus(io_Context, v_Result.getStatus());
                        return v_Result;
                    }
                    MTExecuteResult v_MTExecuteResult = new MTExecuteResult(x, v_Item, (ExecuteElement)v_CallObject, v_Item.gatTimeout(io_Context));
                    v_MTItemResults.add(v_MTExecuteResult);
                    if (this.oneByOne.booleanValue() || v_MTExecuteResult.getTimeout() >= Long.MAX_VALUE) continue;
                    v_IsOrderBy = true;
                }
            }
            if (!Help.isNull(v_MTItemResults)) {
                if (v_IsOrderBy) {
                    Help.toSort(v_MTItemResults, (String[])new String[]{"timeout NumAsc"});
                }
                for (MTExecuteResult v_MTItemResult : v_MTItemResults) {
                    HashMap<String, Object> v_MTItemContext = new HashMap<String, Object>();
                    v_MTItemContext.putAll(io_Context);
                    if (!Help.isNull((String)v_MTItemResult.getMtItem().getContext())) {
                        String v_Context = ValueHelp.replaceByContext(v_MTItemResult.getMtItem().getContext(), v_MTItemContext);
                        Map v_ContextMap = (Map)ValueHelp.getValue(v_Context, Map.class, null, null);
                        v_MTItemContext.putAll(v_ContextMap);
                        v_ContextMap.clear();
                        v_ContextMap = null;
                    }
                    v_MTItemResult.setContext(v_MTItemContext);
                }
                Long v_WaitTime = null;
                v_WaitTime = Help.isNumber((String)this.waitTime) ? Long.valueOf(this.waitTime) : (Long)ValueHelp.getValue(this.waitTime, Long.class, 0L, io_Context);
                long v_TimeoutTotal = 0L;
                for (int x = 0; x < v_MTItemResults.size(); ++x) {
                    MTExecuteResult v_MTItemResult = (MTExecuteResult)v_MTItemResults.get(x);
                    long v_Timeout = v_MTItemResult.getTimeout();
                    if (v_Timeout == Long.MAX_VALUE) {
                        v_Timeout = 0L;
                    } else if (!this.oneByOne.booleanValue()) {
                        if (v_Timeout > v_TimeoutTotal) {
                            v_TimeoutTotal += (v_Timeout -= v_TimeoutTotal);
                        } else {
                            v_Timeout = 1L;
                        }
                    }
                    TimeoutConfig<ExecuteResult> v_Future = this.executeAsync(v_Timeout, v_MTItemResult.getContext(), v_MTItemResult.getCallObject());
                    v_Future.executeAsync();
                    v_MTItemResult.setTimeoutConfig(v_Future);
                    if (this.oneByOne.booleanValue()) {
                        ExecuteResult v_ExecResult = v_Future.get();
                        v_MTItemResult.setResult(v_ExecResult);
                        if (!v_ExecResult.isSuccess()) {
                            if (v_Exception == null) {
                                v_Exception = v_ExecResult.getException();
                                break;
                            }
                        } else {
                            this.refreshReturn(io_Context, v_MTItemResult.getContext(), v_MTItemResult.getMtItem().getReturnID());
                        }
                    }
                    if (v_WaitTime <= 0L || x >= v_MTItemResults.size() - 1) continue;
                    Thread.sleep(v_WaitTime, 0);
                }
                if (!this.oneByOne.booleanValue()) {
                    for (MTExecuteResult v_MTItemResult : v_MTItemResults) {
                        ExecuteResult v_ExecResult = v_MTItemResult.getTimeoutConfig().get();
                        v_MTItemResult.setResult(v_ExecResult);
                        if (!v_ExecResult.isSuccess()) {
                            if (v_Exception != null) continue;
                            v_Exception = v_ExecResult.getException();
                            continue;
                        }
                        this.refreshReturn(io_Context, v_MTItemResult.getContext(), v_MTItemResult.getMtItem().getReturnID());
                    }
                }
            }
            if (v_Exception != null) {
                v_Result.setException(v_Exception, v_MTItemResults);
                this.refreshStatus(io_Context, v_Result.getStatus());
                return v_Result;
            }
            v_Result.setResult(v_MTItemResults);
            this.refreshReturn(io_Context, v_Result.getResult());
            this.refreshStatus(io_Context, v_Result.getStatus());
            this.success(Date.getTimeNano() - v_BeginTime);
            return v_Result;
        }
        catch (Exception exce) {
            v_Result.setException(exce);
            this.refreshStatus(io_Context, v_Result.getStatus());
            return v_Result;
        }
    }

    private TimeoutConfig<ExecuteResult> executeAsync(Long i_Timeout, Map<String, Object> io_Context, ExecuteElement i_CallObject) {
        return new TimeoutConfig<ExecuteResult>(i_Timeout).future(() -> {
            try {
                return CallFlow.execute(i_CallObject, io_Context);
            }
            catch (Exception exce) {
                throw new RuntimeException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "] executeAsync error", exce);
            }
        });
    }

    private void refreshReturn(Map<String, Object> io_Context, Map<String, Object> i_MTItemContext, String i_ReturnID) {
        if (!Help.isNull((String)i_ReturnID) && io_Context != null) {
            io_Context.put(i_ReturnID, CallFlow.getLastResult(i_MTItemContext).getResult());
        }
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = ElementType.MT.getXmlName();
        String v_NewSpace = "\n" + v_LevelN + v_Level1;
        if (!Help.isNull((String)this.getXJavaID())) {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level));
        if (this.oneByOne != null && this.oneByOne.booleanValue()) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("oneByOne", this.oneByOne));
        }
        if (!Help.isNull((String)this.waitTime) && !"0".equals(this.waitTime)) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("waitTime", this.waitTime));
        }
        if (!Help.isNull(this.mtitems)) {
            for (MTItem v_Item : this.mtitems) {
                v_Xml.append(v_Item.toXml(i_Level + 1, v_TreeID));
            }
        }
        if (!Help.isNull((String)this.context)) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("context", this.context, v_NewSpace));
        }
        if (!Help.isNull((String)this.returnID)) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("returnID", this.returnID));
        }
        if (!Help.isNull((String)this.statusID)) {
            v_Xml.append(v_NewSpace).append(IToXml.toValue("statusID", this.statusID));
        }
        if (!Help.isNull(this.route.getSucceeds()) || !Help.isNull(this.route.getExceptions())) {
            v_Xml.append(v_NewSpace).append(IToXml.toBegin("route"));
            if (!Help.isNull(this.route.getSucceeds())) {
                for (RouteItem v_RouteItem : this.route.getSucceeds()) {
                    v_Xml.append(v_NewSpace).append(v_Level1).append(IToXml.toBegin(RouteType.Succeed.getXmlName()));
                    v_Xml.append(v_RouteItem.toXml(i_Level + 1, v_TreeID));
                    v_Xml.append(v_NewSpace).append(v_Level1).append(IToXml.toEnd(RouteType.Succeed.getXmlName()));
                }
            }
            if (!Help.isNull(this.route.getExceptions())) {
                for (RouteItem v_RouteItem : this.route.getExceptions()) {
                    v_Xml.append(v_NewSpace).append(v_Level1).append(IToXml.toBegin(RouteType.Error.getXmlName()));
                    v_Xml.append(v_RouteItem.toXml(i_Level + 1, v_TreeID));
                    v_Xml.append(v_NewSpace).append(v_Level1).append(IToXml.toEnd(RouteType.Error.getXmlName()));
                }
            }
            v_Xml.append(v_NewSpace).append(IToXml.toEnd("route"));
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        return v_Xml.toString();
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull(this.mtitems)) {
            v_Builder.append("MT count\uff1a").append(this.mtitems.size()).append("(");
            for (int x = 0; x < this.mtitems.size(); ++x) {
                MTItem v_Item = this.mtitems.get(x);
                if (x >= 1) {
                    v_Builder.append("\u3001");
                }
                v_Builder.append(v_Item.getCallFlowXID());
            }
            v_Builder.append(")");
        } else {
            v_Builder.append("MT count\uff1a0");
        }
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull(this.mtitems)) {
            v_Builder.append("MT count\uff1a").append(this.mtitems.size()).append("(");
            for (int x = 0; x < this.mtitems.size(); ++x) {
                MTItem v_Item = this.mtitems.get(x);
                if (x >= 1) {
                    v_Builder.append("\u3001");
                }
                v_Builder.append(v_Item.getCallFlowXID());
            }
            v_Builder.append(")");
        } else {
            v_Builder.append("MT count\uff1a0");
        }
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new MTConfig();
    }

    @Override
    public Object cloneMyOnly() {
        MTConfig v_Clone = new MTConfig();
        this.cloneMyOnly(v_Clone);
        if (!Help.isNull(this.mtitems)) {
            for (MTItem v_Item : this.mtitems) {
                v_Clone.setItem((MTItem)v_Item.cloneMyOnly());
            }
        }
        v_Clone.oneByOne = this.oneByOne;
        v_Clone.waitTime = this.waitTime;
        v_Clone.context = this.context;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone MTConfig xid is null.");
        }
        MTConfig v_Clone = (MTConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        if (!Help.isNull(this.mtitems)) {
            for (MTItem v_Item : this.mtitems) {
                MTItem v_CloneItem = new MTItem();
                v_Item.clone(v_CloneItem, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
                v_Clone.setItem(v_CloneItem);
            }
        }
        v_Clone.oneByOne = this.oneByOne;
        v_Clone.waitTime = this.waitTime;
        v_Clone.context = this.context;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone MTConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        MTConfig v_Clone = new MTConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

