/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.execute;

import java.util.List;
import org.hy.common.Help;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.execute.IExecute;
import org.hy.common.callflow.route.RouteItem;
import org.hy.common.callflow.route.SelfLoop;
import org.hy.common.xml.XJava;

public class ExecuteTreeHelp {
    private static ExecuteTreeHelp $Instance = new ExecuteTreeHelp();

    public static ExecuteTreeHelp getInstance() {
        return $Instance;
    }

    public void removeMySelf(ExecuteElement i_ExecObject) {
        if (i_ExecObject == null) {
            throw new NullPointerException("ExecObject is null.");
        }
        this.removeMySelf_SelfLoop(i_ExecObject.getRoute().getSucceeds());
        this.removeMySelf_SelfLoop(i_ExecObject.getRoute().getFaileds());
        this.removeMySelf_SelfLoop(i_ExecObject.getRoute().getExceptions());
        if (!Help.isNull((String)i_ExecObject.getXJavaID())) {
            XJava.remove((String)i_ExecObject.getXJavaID());
        }
    }

    private void removeMySelf_SelfLoop(List<RouteItem> i_Childs) {
        if (!Help.isNull(i_Childs)) {
            for (RouteItem v_RouteItem : i_Childs) {
                ExecuteElement v_Child = v_RouteItem.gatNext();
                if (v_Child instanceof SelfLoop) continue;
                this.removeMySelf(v_Child);
            }
        }
    }

    public void clearTree(ExecuteElement io_ExecObject) {
        if (io_ExecObject == null) {
            throw new NullPointerException("ExecObject is null.");
        }
        io_ExecObject.setTreeID(null);
        this.clearTree_SelfLoop(io_ExecObject.getRoute().getSucceeds());
        this.clearTree_SelfLoop(io_ExecObject.getRoute().getFaileds());
        this.clearTree_SelfLoop(io_ExecObject.getRoute().getExceptions());
    }

    private void clearTree_SelfLoop(List<RouteItem> i_Childs) {
        if (!Help.isNull(i_Childs)) {
            for (RouteItem v_RouteItem : i_Childs) {
                ExecuteElement v_Child = v_RouteItem.gatNext();
                if (v_Child instanceof SelfLoop) continue;
                this.clearTree(v_Child);
            }
        }
    }

    public void calcTree(IExecute io_ExecObject) {
        if (io_ExecObject == null) {
            throw new NullPointerException("ExecObject is null.");
        }
        io_ExecObject.setTreeID(null, ExecuteElement.$TreeID.getMinIndexNo());
        this.calcTreeToChilds(io_ExecObject, io_ExecObject.getTreeID(""));
    }

    private void calcTree(IExecute io_ExecObject, String i_SuperTreeID, int i_IndexNo) {
        String v_TreeID = io_ExecObject.setTreeID(i_SuperTreeID, i_IndexNo);
        this.calcTreeToChilds(io_ExecObject, v_TreeID);
    }

    private void calcTreeToChilds(IExecute io_ExecObject, String i_TreeID) {
        ExecuteElement v_Child;
        int v_IndexNo = ExecuteElement.$TreeID.getMinIndexNo();
        List<RouteItem> v_Childs = null;
        v_Childs = io_ExecObject.getRoute().getSucceeds();
        if (!Help.isNull(v_Childs)) {
            for (RouteItem v_RouteItem : v_Childs) {
                v_Child = v_RouteItem.gatNext();
                if (v_Child instanceof SelfLoop) continue;
                this.calcTree(v_Child, i_TreeID, v_IndexNo++);
            }
        }
        if (!Help.isNull(v_Childs = io_ExecObject.getRoute().getFaileds())) {
            for (RouteItem v_RouteItem : v_Childs) {
                v_Child = v_RouteItem.gatNext();
                if (v_Child instanceof SelfLoop) continue;
                this.calcTree(v_Child, i_TreeID, v_IndexNo++);
            }
        }
        if (!Help.isNull(v_Childs = io_ExecObject.getRoute().getExceptions())) {
            for (RouteItem v_RouteItem : v_Childs) {
                v_Child = v_RouteItem.gatNext();
                if (v_Child instanceof SelfLoop) continue;
                this.calcTree(v_Child, i_TreeID, v_IndexNo++);
            }
        }
    }

    public IExecute findTreeID(IExecute i_ExecObject, String i_TreeID) {
        IExecute v_Ret;
        ExecuteElement v_Child;
        if (i_ExecObject == null) {
            throw new NullPointerException("ExecObject is null.");
        }
        if (Help.isNull((String)i_TreeID)) {
            throw new NullPointerException("TreeID is null.");
        }
        if (i_ExecObject.getTreeLevel(i_TreeID) != null) {
            return i_ExecObject;
        }
        List<RouteItem> v_Childs = null;
        v_Childs = i_ExecObject.getRoute().getSucceeds();
        if (!Help.isNull(v_Childs)) {
            for (RouteItem v_RouteItem : v_Childs) {
                v_Child = v_RouteItem.gatNext();
                if (v_Child instanceof SelfLoop || (v_Ret = this.findTreeID(v_Child, i_TreeID)) == null) continue;
                return v_Ret;
            }
        }
        if (!Help.isNull(v_Childs = i_ExecObject.getRoute().getFaileds())) {
            for (RouteItem v_RouteItem : v_Childs) {
                v_Child = v_RouteItem.gatNext();
                if (v_Child instanceof SelfLoop || (v_Ret = this.findTreeID(v_Child, i_TreeID)) == null) continue;
                return v_Ret;
            }
        }
        if (!Help.isNull(v_Childs = i_ExecObject.getRoute().getExceptions())) {
            for (RouteItem v_RouteItem : v_Childs) {
                v_Child = v_RouteItem.gatNext();
                if (v_Child instanceof SelfLoop || (v_Ret = this.findTreeID(v_Child, i_TreeID)) == null) continue;
                return v_Ret;
            }
        }
        return null;
    }

    public ExecuteResult findExecuteTreeID(ExecuteResult i_ExecResult, String i_ExecuteTreeID) {
        if (i_ExecResult == null) {
            throw new NullPointerException("ExecuteResult is null.");
        }
        if (Help.isNull((String)i_ExecuteTreeID)) {
            throw new NullPointerException("ExecuteTreeID is null.");
        }
        ExecuteResult v_FirstResult = this.getFirstResult(i_ExecResult);
        if (v_FirstResult == null) {
            return null;
        }
        return this.findExecuteTreeID_Inner(v_FirstResult, i_ExecuteTreeID);
    }

    private ExecuteResult findExecuteTreeID_Inner(ExecuteResult i_ExecResult, String i_TreeID) {
        if (i_TreeID.equals(i_ExecResult.getExecuteTreeID())) {
            return i_ExecResult;
        }
        List<ExecuteResult> v_Childs = null;
        v_Childs = i_ExecResult.getNexts();
        if (!Help.isNull(v_Childs)) {
            for (ExecuteResult v_Child : v_Childs) {
                ExecuteResult v_Ret = this.findExecuteTreeID_Inner(v_Child, i_TreeID);
                if (v_Ret == null) continue;
                return v_Ret;
            }
        }
        return null;
    }

    public ExecuteResult findTreeID(ExecuteResult i_ExecResult, String i_TreeID) {
        if (i_ExecResult == null) {
            throw new NullPointerException("ExecuteResult is null.");
        }
        if (Help.isNull((String)i_TreeID)) {
            throw new NullPointerException("TreeID is null.");
        }
        ExecuteResult v_FirstResult = this.getFirstResult(i_ExecResult);
        if (v_FirstResult == null) {
            return null;
        }
        return this.findTreeID_Inner(v_FirstResult, i_TreeID);
    }

    private ExecuteResult findTreeID_Inner(ExecuteResult i_ExecResult, String i_TreeID) {
        if (i_TreeID.equals(i_ExecResult.getTreeID())) {
            return i_ExecResult;
        }
        List<ExecuteResult> v_Childs = i_ExecResult.getNexts();
        if (!Help.isNull(v_Childs)) {
            for (ExecuteResult v_Child : v_Childs) {
                ExecuteResult v_Ret = this.findTreeID_Inner(v_Child, i_TreeID);
                if (v_Ret == null) continue;
                return v_Ret;
            }
        }
        return null;
    }

    public IExecute findFirst(IExecute i_ExecObject) {
        List<IExecute> v_PreviousList;
        if (i_ExecObject == null) {
            throw new NullPointerException("ExecObject is null.");
        }
        if (Help.isNull(i_ExecObject.getTreeIDs())) {
            throw new NullPointerException("ExecObject's TreeIDs is null.");
        }
        if (i_ExecObject.getTreeIDs().size() == 1) {
            String v_TreeID = i_ExecObject.getTreeIDs().iterator().next();
            if (ExecuteElement.$TreeID.getRootLevel() == i_ExecObject.getTreeLevel(v_TreeID).intValue() && ExecuteElement.$TreeID.getMinIndexNo() == i_ExecObject.getTreeNo(v_TreeID).intValue()) {
                return i_ExecObject;
            }
        }
        if (Help.isNull(v_PreviousList = i_ExecObject.gatPrevious())) {
            return i_ExecObject;
        }
        for (IExecute v_Previous : v_PreviousList) {
            IExecute v_SuperRet;
            if (v_Previous instanceof SelfLoop || (v_SuperRet = this.findFirst(v_Previous)) == null) continue;
            return v_SuperRet;
        }
        return null;
    }

    public ExecuteResult findFirst(ExecuteResult i_ExecResult) {
        return this.getFirstResult(i_ExecResult);
    }

    public ExecuteResult getFirstResult(ExecuteResult i_ExecResult) {
        if (i_ExecResult == null) {
            throw new NullPointerException("ExecuteResult is null.");
        }
        if (i_ExecResult.getTreeLevel() == null || i_ExecResult.getTreeNo() == null) {
            throw new NullPointerException("ExecuteResult's TreeLevel or TreeNo is null.");
        }
        if (ExecuteResult.$TreeID.getRootLevel() == i_ExecResult.getTreeLevel().intValue() && ExecuteResult.$TreeID.getMinIndexNo() == i_ExecResult.getTreeNo().intValue()) {
            return i_ExecResult;
        }
        ExecuteResult v_Previous = i_ExecResult.gatPrevious();
        if (v_Previous == null) {
            return i_ExecResult;
        }
        return this.getFirstResult(v_Previous);
    }

    private ExecuteTreeHelp() {
    }
}

