/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.event.mqtt;

import java.util.HashMap;
import java.util.Map;
import org.hy.common.ByteHelp;
import org.hy.common.Help;
import org.hy.common.MethodReflect;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.event.SubscribeConfig;
import org.hy.common.callflow.event.mqtt.SubscribeMQTT;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.mqtt.broker.BrokerConfig;
import org.hy.common.mqtt.broker.XBroker;
import org.hy.common.mqtt.client.enums.MessageFormat;
import org.hy.common.mqtt.client.subscribe.IMqttMessage;
import org.hy.common.mqtt.client.subscribe.IMqttMessageListener;
import org.hy.common.xml.XJava;
import org.hy.common.xml.log.Logger;

public class SubscribeMQTTListener
implements IMqttMessageListener {
    private static Logger $Logger = new Logger(SubscribeMQTTListener.class);
    private SubscribeMQTT subscribe;
    private XBroker broker;
    private SubscribeConfig config;

    public SubscribeMQTTListener(SubscribeMQTT i_Subscribe, SubscribeConfig i_Config) {
        this.subscribe = i_Subscribe;
        if (this.subscribe.getBroker() == null) {
            NullPointerException v_Exce = new NullPointerException(this.subscribe.getXid() + "\uff1aMQTT Broker is null");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        BrokerConfig v_Broker = this.subscribe.getBroker();
        if (Help.isNull((String)v_Broker.getMqttVersion())) {
            NullPointerException v_Exce = new NullPointerException(v_Broker.getXid() + "\uff1aMQTT\u534f\u8bae\u7248\u672c\u4e3a\u7a7a");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        if (Help.isNull((String)v_Broker.getProtocol())) {
            NullPointerException v_Exce = new NullPointerException(v_Broker.getXid() + "\uff1aMQTT\u534f\u8bae\u7c7b\u578b\u4e3a\u7a7a");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        if (Help.isNull((String)v_Broker.getHost())) {
            NullPointerException v_Exce = new NullPointerException(v_Broker.getXid() + "\uff1aMQTT\u670d\u52a1\u914d\u7f6e\u4e3b\u673a\u4e3a\u7a7a");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        if (Help.isNull((Integer)v_Broker.getPort())) {
            NullPointerException v_Exce = new NullPointerException(v_Broker.getXid() + "\uff1aMQTT\u670d\u52a1\u914d\u7f6e\u7aef\u53e3\u4e3a\u7a7a");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        try {
            if (!Help.isNull((String)i_Config.getBrokerPassword())) {
                v_Broker.setUserPassword(i_Config.getBrokerPassword());
            }
            this.config = i_Config;
            this.broker = new XBroker(v_Broker);
            this.broker.getMqttClient().connect();
            this.subscribeMessage();
        }
        catch (Exception exce) {
            $Logger.error((Throwable)exce);
            throw new RuntimeException(exce);
        }
    }

    public boolean subscribeMessage() {
        return this.broker.getMqttClient().subscribe(this.subscribe.getTopic(), this.subscribe.getQoS().intValue(), (IMqttMessageListener)this);
    }

    public boolean unsubscribeClose() {
        this.broker.getMqttClient().unsubscribe(this.subscribe.getTopic());
        return this.broker.getMqttClient().close();
    }

    public void messageArrived(String i_Topic, IMqttMessage i_Message) throws Exception {
        HashMap<String, Object> v_Context = new HashMap<String, Object>();
        if (!Help.isNull(this.config.gatExecuteContext())) {
            v_Context.putAll(this.config.gatExecuteContext());
        }
        if (!Help.isNull((String)this.config.getContext())) {
            try {
                String v_ContextValue = ValueHelp.replaceByContext(this.config.getContext(), v_Context);
                Map v_ContextMap = (Map)ValueHelp.getValue(v_ContextValue, Map.class, null, v_Context);
                v_Context.putAll(v_ContextMap);
                v_ContextMap.clear();
                v_ContextMap = null;
            }
            catch (Exception exce) {
                $Logger.error((Throwable)exce);
                return;
            }
        }
        if (!Help.isNull((String)this.config.getReturnID())) {
            String v_Message = null;
            String v_Format = null;
            if (!Help.isNull((String)this.config.getFormat())) {
                v_Format = ValueHelp.replaceByContext(this.config.getFormat(), v_Context);
                if (MessageFormat.get((String)v_Format) == null) {
                    v_Format = "TEXT";
                }
            } else {
                v_Format = "TEXT";
            }
            v_Message = MessageFormat.Hex.equals((Object)MessageFormat.get((String)v_Format)) ? ByteHelp.bytesToHex((byte[])i_Message.getPayload()) : new String(i_Message.getPayload());
            v_Context.put(this.config.getReturnIDTopic(), i_Topic);
            v_Context.put(this.config.getReturnIDMessage(), v_Message);
        }
        if (Help.isNull((String)this.config.gatCallFlowXID())) {
            $Logger.error((Throwable)new NullPointerException("XID[" + Help.NVL((String)this.config.getXid()) + ":" + Help.NVL((String)this.config.getComment()) + "]'s callFlowXID[" + Help.NVL((String)this.config.gatCallFlowXID(), (String)"?") + "] is null."));
            return;
        }
        Object v_CallObject = XJava.getObject((String)this.config.gatCallFlowXID());
        if (v_CallObject == null) {
            $Logger.error((Throwable)new NullPointerException("XID[" + Help.NVL((String)this.config.getXid()) + ":" + Help.NVL((String)this.config.getComment()) + "]'s CallFlowXID[" + this.config.gatCallFlowXID() + "] is not find."));
            return;
        }
        if (!MethodReflect.isExtendImplement((Object)v_CallObject, ExecuteElement.class)) {
            $Logger.error((Throwable)new NullPointerException("XID[" + Help.NVL((String)this.config.getXid()) + ":" + Help.NVL((String)this.config.getComment()) + "]'s CallFlowXID[" + this.config.gatCallFlowXID() + "] is not ExecuteElement."));
            return;
        }
        ExecuteResult v_Result = CallFlow.execute((ExecuteElement)v_CallObject, v_Context);
        if (v_Result.isSuccess()) {
            $Logger.info("Success\uff1a" + Help.NVL((String)this.config.getXid()) + ":" + Help.NVL((String)this.config.getComment()));
        } else {
            $Logger.error("Failed\uff1a" + Help.NVL((String)this.config.getXid()) + ":" + Help.NVL((String)this.config.getComment()) + "\u3002Error XID = " + v_Result.getExecuteXID(), (Throwable)v_Result.getException());
        }
        ExecuteResult v_FirstResult = CallFlow.getFirstResult(v_Context);
        $Logger.info("\n" + CallFlow.getHelpLog().logs(v_FirstResult));
        v_Context.clear();
        v_Context = null;
    }
}

