/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.route;

import java.util.ArrayList;
import java.util.List;
import org.hy.common.Help;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.route.RouteItem;
import org.hy.common.callflow.route.SelfLoop;

public class RouteConfig {
    private ExecuteElement owner;
    private List<RouteItem> succeeds;
    private List<RouteItem> faileds;
    private List<RouteItem> exceptions;

    public RouteConfig(ExecuteElement i_Owner) {
        this.setOwner(i_Owner);
    }

    public void setOwner(ExecuteElement i_Owner) {
        this.owner = i_Owner;
    }

    public ExecuteElement gatOwner() {
        return this.owner;
    }

    protected void checkSelfLink(ExecuteElement i_Execute) {
        if (i_Execute == null) {
            throw new IllegalArgumentException("XID[" + Help.NVL((String)this.owner.getXid()) + ":" + Help.NVL((String)this.owner.getComment()) + "] add next route Element is null.");
        }
        if (this.owner.equals(i_Execute)) {
            throw new IllegalArgumentException("XID[" + Help.NVL((String)i_Execute.getXid()) + ":" + Help.NVL((String)i_Execute.getComment()) + "] Not allowed to self link.");
        }
    }

    public RouteItem getIf() {
        return new RouteItem(this, RouteType.If);
    }

    public void setIf(RouteItem i_RouteItem) {
        this.setSucceed(i_RouteItem);
    }

    public void setElse(RouteItem i_RouteItem) {
        this.setFailed(i_RouteItem);
    }

    public RouteItem getElse() {
        return this.getFailed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSucceed(RouteItem io_RouteItem) {
        RouteConfig routeConfig = this;
        synchronized (routeConfig) {
            if (Help.isNull(this.succeeds)) {
                this.succeeds = new ArrayList<RouteItem>();
            }
        }
        this.checkSelfLink(io_RouteItem.gatNext());
        io_RouteItem.gatNext().setPrevious(this.owner);
        this.succeeds.add(io_RouteItem);
        this.orderBy();
    }

    public RouteItem getSucceed() {
        return new RouteItem(this, RouteType.Succeed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailed(RouteItem io_RouteItem) {
        RouteConfig routeConfig = this;
        synchronized (routeConfig) {
            if (Help.isNull(this.faileds)) {
                this.faileds = new ArrayList<RouteItem>();
            }
        }
        this.checkSelfLink(io_RouteItem.gatNext());
        io_RouteItem.gatNext().setPrevious(this.owner);
        this.faileds.add(io_RouteItem);
        this.orderBy();
    }

    public RouteItem getFailed() {
        return new RouteItem(this, RouteType.Else);
    }

    public void setError(RouteItem i_RouteItem) {
        this.setException(i_RouteItem);
    }

    public RouteItem getError() {
        return this.getException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(RouteItem io_RouteItem) {
        RouteConfig routeConfig = this;
        synchronized (routeConfig) {
            if (Help.isNull(this.exceptions)) {
                this.exceptions = new ArrayList<RouteItem>();
            }
        }
        this.checkSelfLink(io_RouteItem.gatNext());
        io_RouteItem.gatNext().setPrevious(this.owner);
        this.exceptions.add(io_RouteItem);
        this.orderBy();
    }

    public RouteItem getException() {
        return new RouteItem(this, RouteType.Error);
    }

    public List<RouteItem> getIfs() {
        return this.getSucceeds();
    }

    public void setIfs(List<RouteItem> i_Ifs) {
        this.setSucceeds(i_Ifs);
    }

    public List<RouteItem> getSucceeds() {
        return this.succeeds;
    }

    public void setSucceeds(List<RouteItem> i_Succeeds) {
        if (Help.isNull(i_Succeeds)) {
            this.succeeds = null;
        } else {
            for (RouteItem v_Item : i_Succeeds) {
                this.setSucceed(v_Item);
            }
        }
    }

    public List<RouteItem> getElses() {
        return this.getFaileds();
    }

    public void setElses(List<RouteItem> i_Elses) {
        this.setFaileds(i_Elses);
    }

    public List<RouteItem> getFaileds() {
        return this.faileds;
    }

    public void setFaileds(List<RouteItem> i_Faileds) {
        if (Help.isNull(i_Faileds)) {
            this.faileds = null;
        } else {
            for (RouteItem v_Item : i_Faileds) {
                this.setFailed(v_Item);
            }
        }
    }

    public List<RouteItem> getErrors() {
        return this.getExceptions();
    }

    public void setErrors(List<RouteItem> i_Errors) {
        this.setExceptions(i_Errors);
    }

    public List<RouteItem> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<RouteItem> i_Exceptions) {
        if (Help.isNull(i_Exceptions)) {
            this.exceptions = null;
        } else {
            for (RouteItem v_Item : i_Exceptions) {
                this.setException(v_Item);
            }
        }
    }

    protected synchronized void orderBy() {
        this.orderBy(this.succeeds);
        this.orderBy(this.faileds);
        this.orderBy(this.exceptions);
    }

    private void orderBy(List<RouteItem> io_RouteItems) {
        int x;
        if (Help.isNull(io_RouteItems) || io_RouteItems.size() == 1) {
            return;
        }
        RouteItem v_Last = io_RouteItems.get(io_RouteItems.size() - 1);
        if (v_Last.gatNext() == null || !(v_Last.gatNext() instanceof SelfLoop)) {
            return;
        }
        int v_LastSelfLoopIndex = 0;
        for (x = 0; x < io_RouteItems.size(); ++x) {
            RouteItem v_RouteItem = io_RouteItems.get(x);
            if (v_RouteItem.gatNext() != null && v_RouteItem.gatNext() instanceof SelfLoop) continue;
            v_LastSelfLoopIndex = x;
            break;
        }
        for (x = io_RouteItems.size() - 2; x >= v_LastSelfLoopIndex; --x) {
            io_RouteItems.set(x + 1, io_RouteItems.get(x));
        }
        io_RouteItems.set(v_LastSelfLoopIndex, v_Last);
    }
}

