/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.nesting;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.MethodReflect;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.enums.RouteType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.file.IToXml;
import org.hy.common.callflow.route.RouteItem;
import org.hy.common.callflow.timeout.TimeoutConfig;
import org.hy.common.xml.XJava;
import org.hy.common.xml.log.Logger;

public class NestingConfig
extends ExecuteElement
implements Cloneable {
    private static final Logger $Logger = new Logger(NestingConfig.class);
    private String callFlowXID;
    private String timeout = "0";

    public NestingConfig() {
        this(0L, 0L);
    }

    public NestingConfig(long i_RequestTotal, long i_SuccessTotal) {
        super(i_RequestTotal, i_SuccessTotal);
    }

    @Override
    public String getElementType() {
        return ElementType.Nesting.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteResult execute(String i_SuperTreeID, Map<String, Object> io_Context) {
        Object v_Future;
        long v_BeginTime = this.request();
        Integer v_NestingLevel = CallFlow.getNestingLevel(io_Context);
        ExecuteResult v_NestingBegin = new ExecuteResult(v_NestingLevel, this.getTreeID(i_SuperTreeID), this.xid, this.toString(io_Context) + " BEGIN ");
        ExecuteResult v_NestingEnd = new ExecuteResult(v_NestingLevel, v_NestingBegin.getExecuteTreeID(), this.xid, this.toString(io_Context) + " END ");
        this.refreshStatus(io_Context, v_NestingBegin.getStatus());
        if (Help.isNull((String)this.callFlowXID)) {
            v_NestingBegin.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallFlowXID is null."));
            this.refreshStatus(io_Context, v_NestingBegin.getStatus());
            return v_NestingBegin;
        }
        Object v_CallObject = XJava.getObject((String)this.callFlowXID);
        if (v_CallObject == null) {
            v_NestingBegin.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallFlowXID[" + this.callFlowXID + "] is not find."));
            this.refreshStatus(io_Context, v_NestingBegin.getStatus());
            return v_NestingBegin;
        }
        if (!MethodReflect.isExtendImplement((Object)v_CallObject, ExecuteElement.class)) {
            v_NestingBegin.setException(new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s CallFlowXID[" + this.callFlowXID + "] is not ExecuteElement."));
            this.refreshStatus(io_Context, v_NestingBegin.getStatus());
            return v_NestingBegin;
        }
        Long v_Timeout = null;
        try {
            v_Timeout = this.gatTimeout(io_Context);
        }
        catch (Exception exce) {
            v_NestingBegin.setException(exce);
            this.refreshStatus(io_Context, v_NestingBegin.getStatus());
            return v_NestingBegin;
        }
        ExecuteResult v_SuperFirstResult = CallFlow.getFirstResult(io_Context);
        ExecuteResult v_SuperLastResult = CallFlow.getLastResult(io_Context);
        if (v_SuperLastResult != null) {
            v_NestingBegin.setPrevious(v_SuperLastResult);
        } else {
            v_NestingBegin.setPrevious(null);
        }
        NestingConfig nestingConfig = this;
        synchronized (nestingConfig) {
            io_Context.put("CallFlowLastNestingBeginResult", v_NestingBegin);
            io_Context.put("CallFlowNestingLevel", v_NestingLevel + 1);
        }
        ExecuteElement v_CallFlow = (ExecuteElement)v_CallObject;
        ExecuteResult v_ExceRet = null;
        TimeoutException v_TimeoutExce = null;
        if (v_Timeout > 0L) {
            v_Future = this.executeAsync(v_Timeout, io_Context, v_CallFlow);
            v_ExceRet = ((TimeoutConfig)v_Future).execute();
            if (((TimeoutConfig)v_Future).isError()) {
                if (((TimeoutConfig)v_Future).getException() instanceof TimeoutException) {
                    v_TimeoutExce = (TimeoutException)((TimeoutConfig)v_Future).getException();
                } else if (!CallFlow.getExecuteIsError(io_Context).booleanValue()) {
                    $Logger.error("\u5e94\u5f53\u6c38\u4e0d\u4f1a\u88ab\u6267\u884c\uff0c\u5982\u679c\u6267\u884c\u4e86\uff0c\u7a0b\u5e8f\u5c31\u6709Bug", (Throwable)((TimeoutConfig)v_Future).getException());
                }
            }
        } else {
            v_ExceRet = CallFlow.execute(v_CallFlow, io_Context, CallFlow.getExecuteEvent(io_Context));
        }
        CallFlow.clearTrueReturn(io_Context);
        v_Future = this;
        synchronized (v_Future) {
            if (v_SuperFirstResult != null) {
                io_Context.put("CallFlowFirstExecuteResult", v_SuperFirstResult);
            }
            io_Context.put("CallFlowNestingLevel", v_NestingLevel);
        }
        if (v_TimeoutExce != null) {
            v_ErrorResult = null;
            do {
                if ((v_ErrorResult = CallFlow.getErrorResult(io_Context)) == null) {
                    v_ErrorResult = CallFlow.getLastResult(io_Context);
                }
                if (v_ErrorResult != null) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (v_ErrorResult == null);
            CallFlow.clearError(io_Context);
            v_ErrorResult.addNext(v_NestingEnd);
            v_NestingEnd.setPrevious(v_ErrorResult);
            v_NestingEnd.setTimeout(v_TimeoutExce);
            v_NestingBegin.setTimeout(v_TimeoutExce);
            this.refreshStatus(io_Context, v_NestingBegin.getStatus());
        } else if (CallFlow.getExecuteIsError(io_Context).booleanValue()) {
            v_ErrorResult = CallFlow.getErrorResult(io_Context);
            v_ErrorResult.addNext(v_NestingEnd);
            v_NestingEnd.setPrevious(v_ErrorResult);
            v_NestingEnd.setException(v_ErrorResult.getException());
            v_NestingBegin.setException(v_ErrorResult.getException());
            this.refreshStatus(io_Context, v_NestingBegin.getStatus());
        } else {
            ExecuteResult v_LastResult = CallFlow.getLastResult(io_Context);
            v_LastResult.addNext(v_NestingEnd);
            v_NestingEnd.setPrevious(v_LastResult);
            v_NestingEnd.setResult(v_ExceRet.getResult());
            this.refreshReturn(io_Context, v_ExceRet.getResult());
            this.refreshStatus(io_Context, v_ExceRet.getStatus());
            v_NestingBegin.setResult(v_ExceRet.getResult());
            this.success(Date.getTimeNano() - v_BeginTime);
        }
        return v_NestingBegin;
    }

    private TimeoutConfig<ExecuteResult> executeAsync(Long i_Timeout, Map<String, Object> io_Context, ExecuteElement i_CallFlow) {
        return new TimeoutConfig<ExecuteResult>(i_Timeout).future(() -> CallFlow.execute(i_CallFlow, io_Context, CallFlow.getExecuteEvent(io_Context)));
    }

    public String getCallFlowXID() {
        return ValueHelp.standardRefID(this.callFlowXID);
    }

    public void setCallFlowXID(String i_CallFlowXID) {
        this.callFlowXID = ValueHelp.standardValueID(i_CallFlowXID);
        this.reset(this.getRequestTotal(), this.getSuccessTotal());
        this.keyChange();
    }

    private Long gatTimeout(Map<String, Object> i_Context) throws Exception {
        Long v_Timeout = null;
        v_Timeout = Help.isNumber((String)this.timeout) ? Long.valueOf(this.timeout) : (Long)ValueHelp.getValue(this.timeout, Long.class, 0L, i_Context);
        return v_Timeout;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String i_Timeout) {
        if (Help.isNull((String)i_Timeout)) {
            NullPointerException v_Exce = new NullPointerException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s timeout is null.");
            $Logger.error((Throwable)v_Exce);
            throw v_Exce;
        }
        if (Help.isNumber((String)i_Timeout)) {
            Long v_Timeout = Long.valueOf(i_Timeout);
            if (v_Timeout < 0L) {
                IllegalArgumentException v_Exce = new IllegalArgumentException("XID[" + Help.NVL((String)this.xid) + ":" + Help.NVL((String)this.comment) + "]'s timeout Less than zero.");
                $Logger.error((Throwable)v_Exce);
                throw v_Exce;
            }
            this.timeout = i_Timeout.trim();
        } else {
            this.timeout = ValueHelp.standardRefID(i_Timeout);
        }
    }

    @Override
    public String toXml(int i_Level, String i_SuperTreeID) {
        String v_MinTreeID;
        String v_TreeID = this.getTreeID(i_SuperTreeID);
        if (this.getTreeIDs().size() >= 2 && !v_TreeID.equals(v_MinTreeID = this.getMinTreeID())) {
            return "";
        }
        StringBuilder v_Xml = new StringBuilder();
        String v_Level1 = "    ";
        String v_LevelN = i_Level <= 0 ? "" : StringHelp.lpad((String)"", (int)i_Level, (String)v_Level1);
        String v_XName = ElementType.Nesting.getXmlName();
        if (!Help.isNull((String)this.getXJavaID())) {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBeginID(v_XName, this.getXJavaID()));
        } else {
            v_Xml.append("\n").append(v_LevelN).append(IToXml.toBegin(v_XName));
        }
        v_Xml.append(super.toXml(i_Level));
        if (!Help.isNull((String)this.callFlowXID)) {
            v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(IToXml.toValue("callFlowXID", this.getCallFlowXID()));
        }
        if (!Help.isNull((String)this.timeout) && !"0".equals(this.timeout)) {
            v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(IToXml.toValue("timeout", this.timeout));
        }
        if (!Help.isNull((String)this.returnID)) {
            v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(IToXml.toValue("returnID", this.returnID));
        }
        if (!Help.isNull((String)this.statusID)) {
            v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(IToXml.toValue("statusID", this.statusID));
        }
        if (!Help.isNull(this.route.getSucceeds()) || !Help.isNull(this.route.getExceptions())) {
            v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(IToXml.toBegin("route"));
            if (!Help.isNull(this.route.getSucceeds())) {
                for (RouteItem v_RouteItem : this.route.getSucceeds()) {
                    v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(v_Level1).append(IToXml.toBegin(RouteType.Succeed.getXmlName()));
                    v_Xml.append(v_RouteItem.toXml(i_Level + 1, v_TreeID));
                    v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(v_Level1).append(IToXml.toEnd(RouteType.Succeed.getXmlName()));
                }
            }
            if (!Help.isNull(this.route.getExceptions())) {
                for (RouteItem v_RouteItem : this.route.getExceptions()) {
                    v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(v_Level1).append(IToXml.toBegin(RouteType.Error.getXmlName()));
                    v_Xml.append(v_RouteItem.toXml(i_Level + 1, v_TreeID));
                    v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(v_Level1).append(IToXml.toEnd(RouteType.Error.getXmlName()));
                }
            }
            v_Xml.append("\n").append(v_LevelN).append(v_Level1).append(IToXml.toEnd("route"));
        }
        v_Xml.append("\n").append(v_LevelN).append(IToXml.toEnd(v_XName));
        return v_Xml.toString();
    }

    public String toString(Map<String, Object> i_Context) {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.returnID)) {
            v_Builder.append(":").append(this.returnID).append(" = ");
        }
        v_Builder.append(":");
        if (!Help.isNull((String)this.callFlowXID)) {
            v_Builder.append(this.callFlowXID);
            if (XJava.getObject((String)this.callFlowXID) == null) {
                v_Builder.append(" is NULL");
            }
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(".");
        v_Builder.append("execute(...)");
        return v_Builder.toString();
    }

    public String toString() {
        StringBuilder v_Builder = new StringBuilder();
        if (!Help.isNull((String)this.returnID)) {
            v_Builder.append(":").append(this.returnID).append(" = ");
        }
        v_Builder.append(":");
        if (!Help.isNull((String)this.callFlowXID)) {
            v_Builder.append(this.callFlowXID);
        } else {
            v_Builder.append("?");
        }
        v_Builder.append(".");
        v_Builder.append("execute(...)");
        return v_Builder.toString();
    }

    @Override
    public Object newMy() {
        return new NestingConfig();
    }

    @Override
    public Object cloneMyOnly() {
        NestingConfig v_Clone = new NestingConfig();
        this.cloneMyOnly(v_Clone);
        v_Clone.callFlowXID = this.callFlowXID;
        v_Clone.timeout = this.timeout;
        return v_Clone;
    }

    @Override
    public void clone(Object io_Clone, String i_ReplaceXID, String i_ReplaceByXID, String i_AppendXID, Map<String, ExecuteElement> io_XIDObjects) {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone NestingConfig xid is null.");
        }
        NestingConfig v_Clone = (NestingConfig)io_Clone;
        super.clone(v_Clone, i_ReplaceXID, i_ReplaceByXID, i_AppendXID, io_XIDObjects);
        v_Clone.callFlowXID = this.callFlowXID;
        v_Clone.timeout = this.timeout;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (Help.isNull((String)this.xid)) {
            throw new NullPointerException("Clone NestingConfig xid is null.");
        }
        HashMap<String, ExecuteElement> v_XIDObjects = new HashMap<String, ExecuteElement>();
        Return v_Version = this.parserXIDVersion(this.xid);
        NestingConfig v_Clone = new NestingConfig();
        if (v_Version.booleanValue()) {
            this.clone(v_Clone, v_Version.getParamStr(), "_V" + (v_Version.getParamInt() + 1), "", v_XIDObjects);
        } else {
            this.clone(v_Clone, "", "", "_V", v_XIDObjects);
        }
        v_XIDObjects.clear();
        v_XIDObjects = null;
        return v_Clone;
    }
}

