/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.StringHelp;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.IExecute;
import org.hy.common.callflow.file.TemplateFile;
import org.hy.common.callflow.forloop.ForConfig;
import org.hy.common.callflow.ifelse.ConditionConfig;
import org.hy.common.callflow.nesting.MTConfig;
import org.hy.common.callflow.nesting.NestingConfig;
import org.hy.common.callflow.node.APIConfig;
import org.hy.common.callflow.node.CalculateConfig;
import org.hy.common.callflow.node.NodeConfig;
import org.hy.common.callflow.node.WaitConfig;
import org.hy.common.callflow.returns.ReturnConfig;
import org.hy.common.callflow.route.RouteItem;
import org.hy.common.callflow.route.SelfLoop;
import org.hy.common.file.FileHelp;
import org.hy.common.license.Hash;
import org.hy.common.license.IHash;

public class ExportXml {
    private static final ExportXml $Instance = new ExportXml();
    private static final Map<String, String> $ImportHeads = new LinkedHashMap<String, String>();
    public static final IHash $Hash = new Hash();

    public static ExportXml getInstance() {
        return $Instance;
    }

    public void addImportHead(String i_XmlImportName, Class<?> i_XmlClass) {
        $ImportHeads.put(i_XmlImportName, i_XmlClass.getName());
    }

    public String toXmlImportHeads() {
        StringBuilder v_Imports = new StringBuilder();
        int v_Max = 0;
        for (String string : $ImportHeads.keySet()) {
            v_Max = Help.max((Integer)v_Max, (Integer[])new Integer[]{string.length()});
        }
        ++v_Max;
        for (Map.Entry entry : $ImportHeads.entrySet()) {
            v_Imports.append("    ").append("<import name=\"").append((String)entry.getKey()).append("\"").append(StringHelp.lpad((String)"", (int)(v_Max - ((String)entry.getKey()).length()), (String)" ")).append("class=\"").append((String)entry.getValue()).append("\" />\n");
        }
        return v_Imports.toString();
    }

    public String save(IExecute io_ExecObject) throws IOException {
        return this.save(io_ExecObject, CallFlow.$SavePath);
    }

    public String save(IExecute io_ExecObject, String i_SavePath) throws IOException {
        if (Help.isNull((String)io_ExecObject.getXJavaID())) {
            throw new NullPointerException("ExecObject's xid is null.");
        }
        File v_SavePath = new File(i_SavePath);
        if (!v_SavePath.exists()) {
            throw new IllegalArgumentException("SavePath[" + i_SavePath + "] is not exists.");
        }
        if (!v_SavePath.isDirectory()) {
            throw new IllegalArgumentException("SavePath[" + i_SavePath + "] is not Directory.");
        }
        if (Help.isNull(io_ExecObject.getTreeIDs())) {
            CallFlow.getHelpExecute().calcTree(io_ExecObject);
        }
        FileHelp v_FileHelp = new FileHelp();
        String v_XmlContent = this.export(io_ExecObject);
        String v_Signature = $Hash.encrypt(v_XmlContent);
        String v_SaveName = v_SavePath.getPath() + Help.getSysPathSeparator() + io_ExecObject.getXJavaID() + "_" + Date.getNowTime().getYMD_ID() + "_" + v_Signature + ".xml";
        v_FileHelp.setAppend(false);
        v_FileHelp.setOverWrite(true);
        v_FileHelp.create(v_SaveName, v_XmlContent);
        return v_SaveName;
    }

    public String export(IExecute i_ExecObject) {
        if (i_ExecObject == null) {
            throw new NullPointerException("ExecObject is null.");
        }
        if (Help.isNull(i_ExecObject.getTreeIDs())) {
            CallFlow.getHelpExecute().calcTree(i_ExecObject);
        }
        String v_Imports = this.toXmlImportHeads();
        String v_Content = this.exportToChild(i_ExecObject, i_ExecObject.getTreeIDs().iterator().next());
        String v_Template = this.getTemplateXml();
        while (v_Content.startsWith("\n")) {
            v_Content = v_Content.substring(1);
        }
        return StringHelp.replaceAll((String)v_Template, (String[])new String[]{":Imports", ":Content"}, (String[])new String[]{v_Imports, v_Content});
    }

    private String exportToChild(IExecute i_ExecObject, String i_TreeID) {
        String v_ExecXml;
        ExecuteElement v_Child;
        StringBuilder v_Xml = new StringBuilder();
        List<RouteItem> v_Childs = null;
        v_Childs = i_ExecObject.getRoute().getSucceeds();
        if (!Help.isNull(v_Childs)) {
            for (RouteItem v_RouteItem : v_Childs) {
                v_Child = v_RouteItem.gatNext();
                if (v_Child instanceof SelfLoop) continue;
                v_Xml.append(this.exportToChild(v_Child, v_Child.getTreeID(i_TreeID)));
            }
        }
        if (!Help.isNull(v_Childs = i_ExecObject.getRoute().getFaileds())) {
            for (RouteItem v_RouteItem : v_Childs) {
                v_Child = v_RouteItem.gatNext();
                if (v_Child instanceof SelfLoop) continue;
                v_Xml.append(this.exportToChild(v_Child, v_Child.getTreeID(i_TreeID)));
            }
        }
        if (!Help.isNull(v_Childs = i_ExecObject.getRoute().getExceptions())) {
            for (RouteItem v_RouteItem : v_Childs) {
                v_Child = v_RouteItem.gatNext();
                if (v_Child instanceof SelfLoop) continue;
                v_Xml.append(this.exportToChild(v_Child, v_Child.getTreeID(i_TreeID)));
            }
        }
        if (Help.isNull((String)i_ExecObject.getXJavaID())) {
            if (i_ExecObject instanceof APIConfig) {
                i_ExecObject.setXJavaID("XAPI_" + StringHelp.getUUID9n());
            } else if (i_ExecObject instanceof NodeConfig) {
                i_ExecObject.setXJavaID("XNode_" + StringHelp.getUUID9n());
            } else if (i_ExecObject instanceof WaitConfig) {
                i_ExecObject.setXJavaID("XWait_" + StringHelp.getUUID9n());
            } else if (i_ExecObject instanceof ConditionConfig) {
                i_ExecObject.setXJavaID("XCondition_" + StringHelp.getUUID9n());
            } else if (i_ExecObject instanceof NestingConfig) {
                i_ExecObject.setXJavaID("XNesting_" + StringHelp.getUUID9n());
            } else if (i_ExecObject instanceof MTConfig) {
                i_ExecObject.setXJavaID("XMT_" + StringHelp.getUUID9n());
            } else if (i_ExecObject instanceof CalculateConfig) {
                i_ExecObject.setXJavaID("XCalculate_" + StringHelp.getUUID9n());
            } else if (i_ExecObject instanceof ForConfig) {
                i_ExecObject.setXJavaID("XFor_" + StringHelp.getUUID9n());
            } else if (i_ExecObject instanceof ReturnConfig) {
                i_ExecObject.setXJavaID("XReturn_" + StringHelp.getUUID9n());
            } else {
                if (i_ExecObject instanceof SelfLoop) {
                    throw new RuntimeException("Not allowed to call SelfLoop.toXml().");
                }
                throw new RuntimeException("Unknown type[" + i_ExecObject.getClass().getName() + "] of exception");
            }
        }
        if (!Help.isNull((String)(v_ExecXml = i_ExecObject.toXml(2, i_ExecObject.getTreeSuperID(i_TreeID))))) {
            v_Xml.append("\n\n").append(v_ExecXml);
        }
        return v_Xml.toString();
    }

    private String getTemplateXml() {
        TemplateFile Template = new TemplateFile();
        return Template.getTemplateContent("ExportTemplate.xml", ExportXml.class.getPackageName());
    }

    private ExportXml() {
    }

    static {
        ExportXml.getInstance().addImportHead("xconfig", ArrayList.class);
        ExportXml.getInstance().addImportHead(ElementType.MT.getXmlName(), MTConfig.class);
        ExportXml.getInstance().addImportHead(ElementType.Nesting.getXmlName(), NestingConfig.class);
        ExportXml.getInstance().addImportHead(ElementType.For.getXmlName(), ForConfig.class);
        ExportXml.getInstance().addImportHead(ElementType.Node.getXmlName(), NodeConfig.class);
        ExportXml.getInstance().addImportHead(ElementType.Wait.getXmlName(), WaitConfig.class);
        ExportXml.getInstance().addImportHead(ElementType.Calculate.getXmlName(), CalculateConfig.class);
        ExportXml.getInstance().addImportHead(ElementType.Condition.getXmlName(), ConditionConfig.class);
        ExportXml.getInstance().addImportHead(ElementType.Return.getXmlName(), ReturnConfig.class);
        ExportXml.getInstance().addImportHead(ElementType.Api.getXmlName(), APIConfig.class);
    }
}

