/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.execute;

import java.util.List;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.StringHelp;
import org.hy.common.callflow.CallFlow;
import org.hy.common.callflow.enums.ElementType;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.nesting.MTExecuteResult;

public class ExecuteResultLogHelp {
    private static ExecuteResultLogHelp $Instance = new ExecuteResultLogHelp();

    public static ExecuteResultLogHelp getInstance() {
        return $Instance;
    }

    public String logs(ExecuteResult i_Result) {
        StringBuilder v_Buffer = new StringBuilder();
        int[] v_Lens = this.calcMaxLen(i_Result);
        this.logs_Inner(i_Result, v_Buffer, v_Lens[0] + 1, v_Lens[1] + 1, v_Lens[2]);
        return v_Buffer.toString();
    }

    private int[] calcMaxLen(ExecuteResult i_Result) {
        int v_MaxExecuteTreeIDLen = 0;
        int v_MaxResultTreeIDLen = 0;
        int v_MaxExecuteXIDLen = 0;
        v_MaxExecuteTreeIDLen = Help.max((Integer)i_Result.getExecuteTreeID().length(), (Integer[])new Integer[]{v_MaxExecuteTreeIDLen});
        v_MaxResultTreeIDLen = Help.max((Integer)i_Result.getTreeID().length(), (Integer[])new Integer[]{v_MaxResultTreeIDLen});
        v_MaxExecuteXIDLen = Help.max((Integer)i_Result.getExecuteXID().length(), (Integer[])new Integer[]{v_MaxExecuteXIDLen});
        if (!Help.isNull(i_Result.getNexts())) {
            for (ExecuteResult v_Item : i_Result.getNexts()) {
                int[] v_ItemRet = this.calcMaxLen(v_Item);
                v_MaxExecuteTreeIDLen = Help.max((Integer)v_ItemRet[0], (Integer[])new Integer[]{v_MaxExecuteTreeIDLen});
                v_MaxResultTreeIDLen = Help.max((Integer)v_ItemRet[1], (Integer[])new Integer[]{v_MaxResultTreeIDLen});
                v_MaxExecuteXIDLen = Help.max((Integer)v_ItemRet[2], (Integer[])new Integer[]{v_MaxExecuteXIDLen});
            }
        }
        return new int[]{v_MaxExecuteTreeIDLen, v_MaxResultTreeIDLen, v_MaxExecuteXIDLen};
    }

    private void logs_Inner(ExecuteResult i_Result, StringBuilder io_Logs, int i_MaxExecuteTreeIDLen, int i_MaxResultTreeIDLen, int i_MaxExecuteXIDLen) {
        io_Logs.append(StringHelp.rpad((String)i_Result.getExecuteTreeID(), (int)i_MaxExecuteTreeIDLen, (String)" "));
        io_Logs.append(StringHelp.rpad((String)i_Result.getTreeID(), (int)i_MaxResultTreeIDLen, (String)" "));
        io_Logs.append(Date.toTimeLenNano((long)(i_Result.getEndTime() - i_Result.getBeginTime())));
        io_Logs.append(i_Result.isSuccess() ? " \u6210\u529f " : " \u5f02\u5e38 ");
        io_Logs.append(i_Result.getStatus().getComment()).append(" ");
        io_Logs.append(StringHelp.rpad((String)i_Result.getExecuteXID(), (int)i_MaxExecuteXIDLen, (String)" "));
        io_Logs.append(StringHelp.lpad((String)"", (int)(i_Result.getNestingLevel() * 4), (String)" ")).append(" ");
        io_Logs.append(i_Result.getExecuteLogic()).append(" ");
        if (ElementType.MT.getValue().equals(i_Result.getElementType())) {
            io_Logs.append(Help.NVL((String)i_Result.getComment())).append("\n\n");
            List v_MTResults = (List)i_Result.getResult();
            if (Help.isNull((List)v_MTResults)) {
                io_Logs.append("\u5e76\u53d1\u7ed3\u679c\u4e3a\u7a7a\n");
            } else {
                for (MTExecuteResult v_MTResult : v_MTResults) {
                    io_Logs.append("\u5e76\u53d1\uff1a").append(v_MTResult.getIndexNo()).append(" ").append(v_MTResult.getCallFlowXID()).append(" ").append(Help.NVL((String)v_MTResult.getComment())).append("\n");
                    ExecuteResult v_MTFirstResult = CallFlow.getFirstResult(v_MTResult.getContext());
                    io_Logs.append(this.logs(v_MTFirstResult)).append("\n");
                }
            }
        } else {
            io_Logs.append(Help.NVL((Object)i_Result.getResult())).append(" ");
            io_Logs.append(Help.NVL((String)i_Result.getComment())).append("\n");
        }
        if (!Help.isNull(i_Result.getNexts())) {
            for (ExecuteResult v_Item : i_Result.getNexts()) {
                this.logs_Inner(v_Item, io_Logs, i_MaxExecuteTreeIDLen, i_MaxResultTreeIDLen, i_MaxExecuteXIDLen);
            }
        }
    }

    private ExecuteResultLogHelp() {
    }
}

