/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.execute;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.IExecute;
import org.hy.common.callflow.forloop.ForConfig;
import org.hy.common.callflow.ifelse.ConditionConfig;
import org.hy.common.callflow.ifelse.ConditionItem;
import org.hy.common.callflow.ifelse.IfElse;
import org.hy.common.callflow.nesting.MTConfig;
import org.hy.common.callflow.nesting.MTItem;
import org.hy.common.callflow.nesting.NestingConfig;
import org.hy.common.callflow.node.APIConfig;
import org.hy.common.callflow.node.CalculateConfig;
import org.hy.common.callflow.node.NodeConfig;
import org.hy.common.callflow.node.NodeParam;
import org.hy.common.callflow.node.WaitConfig;
import org.hy.common.callflow.returns.ReturnConfig;
import org.hy.common.callflow.route.RouteItem;
import org.hy.common.callflow.route.SelfLoop;

public class ExecuteElementCheckHelp {
    private static ExecuteElementCheckHelp $Instance = new ExecuteElementCheckHelp();

    public static ExecuteElementCheckHelp getInstance() {
        return $Instance;
    }

    public Return<Object> check(IExecute i_ExecObject) {
        Return v_Ret = new Return(true);
        if (i_ExecObject == null) {
            return v_Ret.set(false).setParamStr("CFlowCheck\uff1aExecObject is null.");
        }
        HashMap<String, Integer> v_XIDs = new HashMap<String, Integer>();
        HashMap<String, Integer> v_ForXIDs = new HashMap<String, Integer>();
        if (this.check((Return<Object>)v_Ret, i_ExecObject, v_XIDs, v_ForXIDs) && !Help.isNull(v_ForXIDs)) {
            for (Map.Entry v_Item : v_ForXIDs.entrySet()) {
                if ((Integer)v_Item.getValue() > 0) continue;
                v_Ret.set(false).setParamStr("CFlowCheck\uff1aFor.xid[" + (String)v_Item.getKey() + "] refXID count is 0.");
                break;
            }
        }
        if (v_Ret.get()) {
            ((ExecuteElement)i_ExecObject).checkOK();
        }
        v_XIDs.clear();
        v_ForXIDs.clear();
        return v_Ret;
    }

    private boolean check(Return<Object> io_Result, IExecute i_ExecObject, Map<String, Integer> io_XIDs, Map<String, Integer> io_ForXIDs) {
        if (!Help.isNull((String)i_ExecObject.getXJavaID())) {
            Integer v_RefCount = io_XIDs.get(i_ExecObject.getXJavaID());
            if (v_RefCount != null) {
                if (i_ExecObject.gatPrevious() != null && v_RefCount < i_ExecObject.gatPrevious().size() - 1) {
                    io_XIDs.put(i_ExecObject.getXJavaID(), v_RefCount + 1);
                    return true;
                }
                io_Result.set(false).setParamStr("CFlowCheck\uff1aXID[" + i_ExecObject.getXJavaID() + "] cannot be repeated.");
                return false;
            }
            io_XIDs.put(i_ExecObject.getXJavaID(), 0);
        }
        if (i_ExecObject instanceof ForConfig) {
            ForConfig v_For = (ForConfig)i_ExecObject;
            if (Help.isNull((String)v_For.getXid())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aForConfig.xid is null.");
                return false;
            }
            if (Help.isNull((String)v_For.getEnd())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aForConfig[" + Help.NVL((String)v_For.getXid()) + "].end is null.");
                return false;
            }
            io_ForXIDs.put(i_ExecObject.getXJavaID(), 0);
        } else if (i_ExecObject instanceof MTConfig) {
            MTConfig v_MT = (MTConfig)i_ExecObject;
            if (Help.isNull(v_MT.getMtitems())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].Mtitems is null.");
                return false;
            }
            int x = 0;
            for (MTItem v_MTItem : v_MT.getMtitems()) {
                if (Help.isNull((String)v_MTItem.getCallFlowXID())) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].callFlowXID is null.");
                    return false;
                }
                if (v_MTItem.getCallFlowXID().equals(v_MT.getXJavaID())) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].callFlowXID[" + v_MTItem.getCallFlowXID() + "] cannot nest itself.");
                    return false;
                }
                if (!Help.isNull((String)v_MTItem.getValueXIDA())) {
                    if (v_MTItem.getComparer() == null) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].comparer is null.");
                        return false;
                    }
                    if (!ValueHelp.isRefID(v_MTItem.getValueXIDA()) && Help.isNull((String)v_MTItem.getValueClass())) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].valueXIDA is Normal type ,but valueClass is null.");
                        return false;
                    }
                }
                if (!Help.isNull((String)v_MTItem.getValueXIDB())) {
                    if (Help.isNull((String)v_MTItem.getValueXIDA())) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].valueXIDA is null.");
                        return false;
                    }
                    if (v_MTItem.getComparer() == null) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].comparer is null.");
                        return false;
                    }
                    if (!ValueHelp.isRefID(v_MTItem.getValueXIDB()) && Help.isNull((String)v_MTItem.getValueClass())) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aMTConfig[" + Help.NVL((String)v_MT.getXid()) + "].[" + x + "].valueXIDB is Normal type ,but valueClass is null.");
                        return false;
                    }
                }
                ++x;
            }
        } else if (i_ExecObject instanceof NestingConfig) {
            NestingConfig v_Nesting = (NestingConfig)i_ExecObject;
            if (Help.isNull((String)v_Nesting.getCallFlowXID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aNestingConfig[" + Help.NVL((String)v_Nesting.getXid()) + "].callFlowXID is null.");
                return false;
            }
            if (v_Nesting.getCallFlowXID().equals(i_ExecObject.getXJavaID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aNestingConfig.callFlowXID[" + v_Nesting.getCallFlowXID() + "] cannot nest itself.");
                return false;
            }
        } else if (i_ExecObject instanceof CalculateConfig) {
            CalculateConfig v_Calculate = (CalculateConfig)i_ExecObject;
            if (Help.isNull((String)v_Calculate.getCalc())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aCalculateConfig[" + Help.NVL((String)v_Calculate.getXid()) + "].calc is null.");
                return false;
            }
        } else if (i_ExecObject instanceof WaitConfig) {
            WaitConfig v_Wait = (WaitConfig)i_ExecObject;
            if ("0".equals(v_Wait.getWaitTime())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aWaitConfig[" + Help.NVL((String)v_Wait.getXid()) + "].waitTime is 0.");
                return false;
            }
        } else if (i_ExecObject instanceof ReturnConfig) {
            ReturnConfig v_Return = (ReturnConfig)i_ExecObject;
            if (Help.isNull((String)v_Return.getRetValue())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aReturnConfig[" + Help.NVL((String)v_Return.getXid()) + "].retValue is null.");
                return false;
            }
            if (!ValueHelp.isRefID(v_Return.getRetValue()) && Help.isNull((String)v_Return.getRetClass())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aReturnConfig[" + Help.NVL((String)v_Return.getXid()) + "] retValue is Normal type ,but retClass is null.");
                return false;
            }
            if (!Help.isNull((String)v_Return.getRetDefault()) && !ValueHelp.isRefID(v_Return.getRetDefault()) && Help.isNull((String)v_Return.getRetClass())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aReturnConfig[" + Help.NVL((String)v_Return.getXid()) + "] retDefault is Normal type ,but retClass is null.");
                return false;
            }
        } else if (i_ExecObject instanceof ConditionConfig) {
            ConditionConfig v_Condition = (ConditionConfig)i_ExecObject;
            if (v_Condition.getLogical() == null) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)v_Condition.getXid()) + "].logical is null.");
                return false;
            }
            if (Help.isNull(v_Condition.getItems())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)v_Condition.getXid()) + "] has no condition items.");
                return false;
            }
            this.check_Condition(v_Condition, io_Result, i_ExecObject, io_XIDs, io_ForXIDs);
        } else if (i_ExecObject instanceof APIConfig) {
            APIConfig v_API = (APIConfig)i_ExecObject;
            if (Help.isNull((String)v_API.getUrl())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aAPIConfig[" + Help.NVL((String)v_API.getXid()) + "].url is null.");
                return false;
            }
        } else if (i_ExecObject instanceof NodeConfig) {
            NodeConfig v_Node = (NodeConfig)i_ExecObject;
            if (Help.isNull((String)v_Node.getCallXID())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aNodeConfig[" + Help.NVL((String)v_Node.getXid()) + "].callXID is null.");
                return false;
            }
            if (Help.isNull((String)v_Node.getCallMethod())) {
                io_Result.set(false).setParamStr("CFlowCheck\uff1aNodeConfig[" + Help.NVL((String)v_Node.getXid()) + "].callMethod is null.");
                return false;
            }
            if (!Help.isNull(v_Node.getCallParams())) {
                int x = 0;
                for (NodeParam v_NodeParam : v_Node.getCallParams()) {
                    ++x;
                    if (v_NodeParam.getValue() == null && v_NodeParam.getValueDefault() == null) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aNodeConfig[" + Help.NVL((String)v_Node.getXid()) + "].callParams[" + x + "] value and valueDefault is null.");
                        return false;
                    }
                    if (!Help.isNull((String)v_NodeParam.getValue()) && !ValueHelp.isRefID(v_NodeParam.getValue()) && Help.isNull((String)v_NodeParam.getValueClass())) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aNodeConfig[" + Help.NVL((String)v_Node.getXid()) + "].callParams[" + x + "] value is Normal type ,but valueClass is null.");
                        return false;
                    }
                    if (Help.isNull((String)v_NodeParam.getValueDefault()) || ValueHelp.isRefID(v_NodeParam.getValueDefault()) || !Help.isNull((String)v_NodeParam.getValueClass())) continue;
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aNodeConfig[" + Help.NVL((String)v_Node.getXid()) + "].callParams[" + x + "] valueDefault is Normal type ,but valueClass is null.");
                    return false;
                }
            }
        }
        if (this.check_SelfLoop(i_ExecObject.getRoute().getSucceeds(), io_Result, i_ExecObject, io_XIDs, io_ForXIDs)) {
            if (this.check_SelfLoop(i_ExecObject.getRoute().getFaileds(), io_Result, i_ExecObject, io_XIDs, io_ForXIDs)) {
                return this.check_SelfLoop(i_ExecObject.getRoute().getExceptions(), io_Result, i_ExecObject, io_XIDs, io_ForXIDs);
            }
            return false;
        }
        return false;
    }

    private boolean check_Condition(ConditionConfig i_Condition, Return<Object> io_Result, IExecute i_ExecObject, Map<String, Integer> io_XIDs, Map<String, Integer> io_ForXIDs) {
        if (i_Condition.getLogical() == null) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "].logical is null.");
            return false;
        }
        if (Help.isNull(i_Condition.getItems())) {
            io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "] has no condition items.");
            return false;
        }
        for (IfElse v_Item : i_Condition.getItems()) {
            if (v_Item instanceof ConditionConfig) {
                if (this.check_Condition((ConditionConfig)v_Item, io_Result, i_ExecObject, io_XIDs, io_ForXIDs)) continue;
                return false;
            }
            if (v_Item instanceof ConditionItem) {
                ConditionItem v_CItem = (ConditionItem)v_Item;
                if (v_CItem.getComparer() == null) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "].comparer is null.");
                    return false;
                }
                if (Help.isNull((String)v_CItem.getValueXIDA())) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "].valueXIDA is null.");
                    return false;
                }
                if (!ValueHelp.isRefID(v_CItem.getValueXIDA()) && Help.isNull((String)v_CItem.getValueClass())) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "] valueXIDA is Normal type ,but valueClass is null.");
                    return false;
                }
                if (Help.isNull((String)v_CItem.getValueXIDB()) || ValueHelp.isRefID(v_CItem.getValueXIDB()) || !Help.isNull((String)v_CItem.getValueClass())) continue;
                io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "] valueXIDB is Normal type ,but valueClass is null.");
                return false;
            }
            io_Result.set(false).setParamStr("CFlowCheck\uff1aConditionConfig[" + Help.NVL((String)i_ExecObject.getXJavaID()) + "].item is unknown type.");
            return false;
        }
        return true;
    }

    private boolean check_SelfLoop(List<RouteItem> i_Childs, Return<Object> io_Result, IExecute i_ExecObject, Map<String, Integer> io_XIDs, Map<String, Integer> io_ForXIDs) {
        if (!Help.isNull(i_Childs)) {
            for (RouteItem v_RouteItem : i_Childs) {
                ExecuteElement v_Child = v_RouteItem.gatNext();
                if (v_Child == null) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aRouteItem.next is null.");
                    return false;
                }
                if (v_Child instanceof SelfLoop) {
                    SelfLoop v_SelfLoop = (SelfLoop)v_Child;
                    String v_RefXID = v_SelfLoop.gatRefXID();
                    Integer v_RefCount = io_XIDs.get(v_RefXID);
                    if (v_RefCount == null) {
                        io_Result.set(false).setParamStr("CFlowCheck\uff1aSelfLoop.RefXID[" + v_SelfLoop.getRefXID() + "] is not exists.");
                        return false;
                    }
                    io_XIDs.put(v_RefXID, v_RefCount + 1);
                    v_RefCount = io_ForXIDs.get(v_RefXID);
                    if (v_RefCount == null) continue;
                    io_ForXIDs.put(v_RefXID, v_RefCount + 1);
                    continue;
                }
                if (v_Child == v_RouteItem.gatOwner().gatOwner()) {
                    io_Result.set(false).setParamStr("CFlowCheck\uff1aRouteItem.next cannot be itself[" + Help.NVL((String)v_RouteItem.gatOwner().gatOwner().getXid()) + "].");
                    return false;
                }
                if (this.check(io_Result, v_Child, io_XIDs, io_ForXIDs)) continue;
                return false;
            }
        }
        return true;
    }

    private ExecuteElementCheckHelp() {
    }
}

