/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.enums;

import org.hy.common.MethodReflect;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Comparer {
    Equal("==", "\u7b49\u4e8e"){

        @Override
        public <V extends Comparable<V>> boolean compare(V i_A, V i_B) {
            if (i_A == null) {
                return i_B == null;
            }
            return i_A.equals(i_B);
        }

        @Override
        public boolean compare(Object i_A, Object i_B) {
            if (i_A == null) {
                return i_B == null;
            }
            return i_A.equals(i_B);
        }
    }
    ,
    EqualNot("!=", "\u4e0d\u7b49\u4e8e"){

        @Override
        public <V extends Comparable<V>> boolean compare(V i_A, V i_B) {
            if (i_A == null) {
                return i_B != null;
            }
            return !i_A.equals(i_B);
        }

        @Override
        public boolean compare(Object i_A, Object i_B) {
            if (i_A == null) {
                return i_B != null;
            }
            return !i_A.equals(i_B);
        }
    }
    ,
    Greater(">", "\u5927\u4e8e"){

        @Override
        public <V extends Comparable<V>> boolean compare(V i_A, V i_B) {
            if (i_A == null) {
                if (i_B == null) {
                    return false;
                }
                return false;
            }
            return i_A.compareTo(i_B) > 0;
        }

        @Override
        public boolean compare(Object i_A, Object i_B) {
            if (i_A == null) {
                if (i_B == null) {
                    return false;
                }
                return false;
            }
            if (i_B == null) {
                return true;
            }
            if (i_A == i_B) {
                return false;
            }
            if (i_A.getClass().equals(i_B.getClass()) && MethodReflect.isExtendImplement((Object)i_A, Comparable.class)) {
                return ((Comparable)i_A).compareTo(i_B) > 0;
            }
            return i_A.hashCode() > i_B.hashCode();
        }
    }
    ,
    GreaterEqual(">=", "\u5927\u4e8e\u7b49\u4e8e"){

        @Override
        public <V extends Comparable<V>> boolean compare(V i_A, V i_B) {
            if (i_A == null) {
                return i_B == null;
            }
            return i_A.compareTo(i_B) >= 0;
        }

        @Override
        public boolean compare(Object i_A, Object i_B) {
            if (i_A == null) {
                return i_B == null;
            }
            if (i_B == null) {
                return true;
            }
            if (i_A == i_B) {
                return true;
            }
            if (i_A.getClass().equals(i_B.getClass()) && MethodReflect.isExtendImplement((Object)i_A, Comparable.class)) {
                return ((Comparable)i_A).compareTo(i_B) >= 0;
            }
            return i_A.hashCode() >= i_B.hashCode();
        }
    }
    ,
    Less("<", "\u5c0f\u4e8e"){

        @Override
        public <V extends Comparable<V>> boolean compare(V i_A, V i_B) {
            if (i_A == null) {
                if (i_B == null) {
                    return false;
                }
                return false;
            }
            return i_A.compareTo(i_B) < 0;
        }

        @Override
        public boolean compare(Object i_A, Object i_B) {
            if (i_A == null) {
                if (i_B == null) {
                    return false;
                }
                return false;
            }
            if (i_B == null) {
                return false;
            }
            if (i_A == i_B) {
                return false;
            }
            if (i_A.getClass().equals(i_B.getClass()) && MethodReflect.isExtendImplement((Object)i_A, Comparable.class)) {
                return ((Comparable)i_A).compareTo(i_B) < 0;
            }
            return i_A.hashCode() < i_B.hashCode();
        }
    }
    ,
    LessEqual("<=", "\u5c0f\u4e8e\u7b49\u4e8e"){

        @Override
        public <V extends Comparable<V>> boolean compare(V i_A, V i_B) {
            if (i_A == null) {
                return i_B == null;
            }
            return i_A.compareTo(i_B) <= 0;
        }

        @Override
        public boolean compare(Object i_A, Object i_B) {
            if (i_A == null) {
                return i_B == null;
            }
            if (i_B == null) {
                return false;
            }
            if (i_A == i_B) {
                return true;
            }
            if (i_A.getClass().equals(i_B.getClass()) && MethodReflect.isExtendImplement((Object)i_A, Comparable.class)) {
                return ((Comparable)i_A).compareTo(i_B) <= 0;
            }
            return i_A.hashCode() <= i_B.hashCode();
        }
    };

    private String value;
    private String comment;

    public abstract <V extends Comparable<V>> boolean compare(V var1, V var2);

    public abstract boolean compare(Object var1, Object var2);

    public static Comparer get(String i_Value) {
        if (i_Value == null) {
            return null;
        }
        String v_Value = i_Value.trim();
        for (Comparer v_Enum : Comparer.values()) {
            if (!v_Enum.value.equals(v_Value)) continue;
            return v_Enum;
        }
        return null;
    }

    private Comparer(String i_Value, String i_Comment) {
        this.value = i_Value;
        this.comment = i_Comment;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return this.value;
    }
}

