/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow.common;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.MethodReflect;
import org.hy.common.StringHelp;
import org.hy.common.callflow.CallFlow;
import org.hy.common.xml.XJSON;
import org.hy.common.xml.XJava;
import org.hy.common.xml.log.Logger;

public class ValueHelp {
    private static final Logger $Logger = new Logger(ValueHelp.class);
    public static final String $Split = ".";

    public static boolean isRefID(String i_RefID) {
        return i_RefID.startsWith(":");
    }

    public static String standardValueID(String i_ValueID) {
        if (!Help.isNull((String)i_ValueID)) {
            String v_ValueID = i_ValueID.trim();
            if (v_ValueID.equals(":")) {
                throw new IllegalArgumentException("ValueID[" + i_ValueID + "] is error.");
            }
            if (v_ValueID.startsWith(":")) {
                v_ValueID = v_ValueID.substring(1);
            }
            return v_ValueID;
        }
        return null;
    }

    public static String standardRefID(String i_RefID) {
        if (Help.isNull((String)i_RefID)) {
            return null;
        }
        String v_RefID = i_RefID.trim();
        if (v_RefID.equals(":")) {
            throw new IllegalArgumentException("RefID[" + v_RefID + "] is error.");
        }
        if (!v_RefID.startsWith(":")) {
            return ":" + v_RefID;
        }
        return v_RefID;
    }

    public static Object getValue(String i_ValueXID, Class<?> i_ValueClass, Object i_Default, Map<String, Object> i_Context) throws Exception {
        Object v_Value = i_ValueXID;
        if (i_ValueXID == null) {
            if (i_Default != null) {
                return ValueHelp.toObject(i_Default, i_ValueClass);
            }
        } else if (i_ValueXID.startsWith(":")) {
            String v_ValueID = i_ValueXID.trim().substring(":".length());
            if ("CallFlowContext".equals(v_ValueID)) {
                return i_Context;
            }
            if ("CallFlowErrorResult".equals(v_ValueID)) {
                return CallFlow.getErrorResult(i_Context);
            }
            if ("CallFlowWorkID".equals(v_ValueID)) {
                return CallFlow.getWorkID(i_Context);
            }
            String v_YYYZZZ = null;
            int v_Index = v_ValueID.indexOf($Split);
            if (v_Index > 0) {
                if (v_Index + 1 < v_ValueID.length()) {
                    v_YYYZZZ = v_ValueID.substring(v_Index + 1);
                }
                v_ValueID = v_ValueID.substring(0, v_Index);
            }
            if (!Help.isNull(i_Context) && (v_Value = i_Context.get(v_ValueID)) != null) {
                if (v_YYYZZZ != null) {
                    return ValueHelp.toObject(ValueHelp.getYYYZZZ(v_Value, v_YYYZZZ), i_ValueClass);
                }
                return ValueHelp.toObject(v_Value, i_ValueClass);
            }
            v_Value = XJava.getObject((String)v_ValueID);
            if (v_Value != null) {
                if (v_YYYZZZ != null) {
                    return ValueHelp.toObject(ValueHelp.getYYYZZZ(v_Value, v_YYYZZZ), i_ValueClass);
                }
                return ValueHelp.toObject(v_Value, i_ValueClass);
            }
            if (v_Value == null) {
                v_Value = ValueHelp.toObject(i_Default, i_ValueClass);
            }
        } else if (Help.isBasicDataType(i_ValueClass)) {
            v_Value = Help.toObject(i_ValueClass, (String)i_ValueXID);
        } else if (i_ValueClass != null) {
            XJSON v_XJson = new XJSON();
            v_Value = v_XJson.toJava(i_ValueXID, i_ValueClass);
        }
        return v_Value;
    }

    private static Object toObject(Object i_Value, Class<?> i_ValueClass) throws Exception {
        if (i_Value != null && i_ValueClass != null) {
            if (Help.isBasicDataType(i_ValueClass)) {
                return Help.toObject(i_ValueClass, (String)i_Value.toString());
            }
            if (String.class.equals(i_Value.getClass()) && MethodReflect.isExtendImplement(i_ValueClass, Map.class)) {
                XJSON v_XJson = new XJSON();
                return v_XJson.toJava(i_Value.toString(), Map.class);
            }
        }
        return i_Value;
    }

    public static Object getYYYZZZ(Object i_Object, String i_YYYZZZ) {
        try {
            if (MethodReflect.isExtendImplement((Object)i_Object, Map.class)) {
                return MethodReflect.getMapValue((Map)((Map)i_Object), (String)i_YYYZZZ);
            }
            MethodReflect v_MR = new MethodReflect(i_Object, i_YYYZZZ, true, -1);
            return v_MR.invokeForInstance(i_Object);
        }
        catch (Exception exce) {
            $Logger.error((Object)exce, "getYYYZZZ(" + i_Object.toString() + " ," + i_YYYZZZ + ") is error.", new Object[0]);
            return null;
        }
    }

    public static String getExpression(Object i_Value) {
        if (i_Value == null) {
            return ValueHelp.getExpression(null, null);
        }
        return ValueHelp.getExpression(i_Value.toString(), i_Value.getClass());
    }

    public static String getExpression(String i_Value, Class<?> i_ValueClass) {
        StringBuilder v_Builder = new StringBuilder();
        if (i_Value == null) {
            v_Builder.append("NULL");
        } else if (i_ValueClass == null) {
            v_Builder.append(i_Value);
        } else if (i_ValueClass.equals(String.class)) {
            v_Builder.append("\"").append(i_Value).append("\"");
        } else if (i_ValueClass.equals(Character.class)) {
            v_Builder.append("'").append(i_Value).append("'");
        } else if (i_ValueClass.equals(Long.class)) {
            v_Builder.append(i_Value).append("L");
        } else if (i_ValueClass.equals(Float.class)) {
            v_Builder.append(i_Value).append("F");
        } else if (i_ValueClass.equals(Double.class)) {
            v_Builder.append(i_Value).append("D");
        } else {
            v_Builder.append(i_Value);
        }
        return v_Builder.toString();
    }

    public static String replaceByContext(String i_Value, Map<String, Object> i_Context) {
        HashMap<CallSite, Object> v_Context = new HashMap<CallSite, Object>();
        for (Map.Entry<String, Object> v_Item : i_Context.entrySet()) {
            v_Context.put((CallSite)((Object)(":" + v_Item.getKey())), v_Item.getValue());
        }
        String v_NewValue = StringHelp.replaceAll((String)i_Value, v_Context);
        v_Context.clear();
        v_Context = null;
        return v_NewValue;
    }
}

