/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.callflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.callflow.clone.CloneableHelp;
import org.hy.common.callflow.common.ValueHelp;
import org.hy.common.callflow.execute.ExecuteElement;
import org.hy.common.callflow.execute.ExecuteElementCheckHelp;
import org.hy.common.callflow.execute.ExecuteResult;
import org.hy.common.callflow.execute.ExecuteResultLogHelp;
import org.hy.common.callflow.execute.ExecuteTreeHelp;
import org.hy.common.callflow.execute.IExecute;
import org.hy.common.callflow.execute.IExecuteEvent;
import org.hy.common.callflow.file.ExportXml;
import org.hy.common.callflow.file.ImportXML;
import org.hy.common.callflow.ifelse.ConditionConfig;
import org.hy.common.callflow.nesting.NestingConfig;
import org.hy.common.callflow.node.CalculateConfig;
import org.hy.common.callflow.node.WaitConfig;
import org.hy.common.callflow.route.RouteItem;
import org.hy.common.callflow.route.SelfLoop;
import org.hy.common.xml.XJava;

public class CallFlow {
    public static String $SavePath = Help.getSysTempPath();
    public static final String $WorkID = "CallFlowWorkID";
    public static final String $FirstExecuteResult = "CallFlowFirstExecuteResult";
    public static final String $LastExecuteResult = "CallFlowLastExecuteResult";
    public static final String $LastNestingBeginResult = "CallFlowLastNestingBeginResult";
    public static final String $NestingLevel = "CallFlowNestingLevel";
    public static final String $ExecuteIsError = "CallFlowExecuteIsError";
    public static final String $CallFlowReturn = "CallFlowReturn";
    public static final String $CallFlowReturnValue = "CallFlowReturnValue";
    public static final String $ErrorResult = "CallFlowErrorResult";
    public static final String $ExecuteEvent = "CallFlowExecuteEvent";
    public static final String $Context = "CallFlowContext";
    public static final String $WaitCounter = "CallFlowWaitCounter";

    public static boolean isSystemXID(String i_XID) {
        if (Help.isNull((String)i_XID)) {
            return false;
        }
        String v_XID = ValueHelp.standardValueID(i_XID);
        return $WorkID.equals(v_XID) || $FirstExecuteResult.equals(v_XID) || $LastExecuteResult.equals(v_XID) || $LastNestingBeginResult.equals(v_XID) || $NestingLevel.equals(v_XID) || $ExecuteIsError.equals(v_XID) || $ErrorResult.equals(v_XID) || $ExecuteEvent.equals(v_XID) || $Context.equals(v_XID) || $WaitCounter.equals(v_XID) || $CallFlowReturn.equals(v_XID) || $CallFlowReturnValue.equals(v_XID);
    }

    public static Map<String, Object> setWorkID(Map<String, Object> io_Context, String i_WorkID) {
        io_Context.put($WorkID, i_WorkID);
        return io_Context;
    }

    public static String getWorkID(Map<String, Object> i_Context) {
        return (String)i_Context.get($WorkID);
    }

    public static Object getReturnValue(Map<String, Object> i_Context) {
        return i_Context.get($CallFlowReturnValue);
    }

    public static boolean isTrueReturn(Map<String, Object> i_Context) {
        return i_Context.get($CallFlowReturn) != null;
    }

    public static void clearTrueReturn(Map<String, Object> io_Context) {
        io_Context.remove($CallFlowReturn);
    }

    public static ExecuteResult getFirstResult(Map<String, Object> i_Context) {
        return (ExecuteResult)i_Context.get($FirstExecuteResult);
    }

    public static ExecuteResult getLastResult(Map<String, Object> i_Context) {
        return (ExecuteResult)i_Context.get($LastExecuteResult);
    }

    public static Integer getNestingLevel(Map<String, Object> i_Context) {
        return (Integer)i_Context.get($NestingLevel);
    }

    public static IExecuteEvent getExecuteEvent(Map<String, Object> i_Context) {
        return (IExecuteEvent)i_Context.get($ExecuteEvent);
    }

    public static Boolean getExecuteIsError(Map<String, Object> i_Context) {
        return (Boolean)i_Context.get($ExecuteIsError);
    }

    public static ExecuteResult getErrorResult(Map<String, Object> i_Context) {
        return (ExecuteResult)i_Context.get($ErrorResult);
    }

    public static void clearError(Map<String, Object> io_Context) {
        io_Context.put($ExecuteIsError, false);
        io_Context.remove($ErrorResult);
    }

    private static ExecuteResult putError(Map<String, Object> io_Context, ExecuteResult i_ErrorResult) {
        io_Context.put($ExecuteIsError, true);
        io_Context.put($ErrorResult, i_ErrorResult);
        return i_ErrorResult;
    }

    public static ExecuteTreeHelp getHelpExecute() {
        return ExecuteTreeHelp.getInstance();
    }

    public static ExecuteElementCheckHelp getHelpCheck() {
        return ExecuteElementCheckHelp.getInstance();
    }

    public static ExportXml getHelpExport() {
        return ExportXml.getInstance();
    }

    public static ImportXML getHelpImport() {
        return ImportXML.getInstance();
    }

    public static ExecuteResultLogHelp getHelpLog() {
        return ExecuteResultLogHelp.getInstance();
    }

    public static CloneableHelp getHelpClone() {
        return CloneableHelp.getInstance();
    }

    public static ExecuteResult execute(String i_ExecXID, Map<String, Object> io_Context) {
        return CallFlow.execute(i_ExecXID, io_Context, null);
    }

    public static ExecuteResult execute(String i_ExecXID, Map<String, Object> io_Context, IExecuteEvent i_Event) {
        IExecute v_ExecObject = (IExecute)XJava.getObject((String)i_ExecXID);
        return CallFlow.execute(v_ExecObject, io_Context, i_Event);
    }

    public static ExecuteResult execute(IExecute i_ExecObject, Map<String, Object> io_Context) {
        return CallFlow.execute(i_ExecObject, io_Context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecuteResult execute(IExecute i_ExecObject, Map<String, Object> io_Context, IExecuteEvent i_Event) {
        Return<Object> v_CheckRet;
        ExecuteResult v_LastResult = new ExecuteResult();
        if (i_ExecObject == null) {
            return v_LastResult.setException(new NullPointerException("ExecObject is null."));
        }
        if (((ExecuteElement)i_ExecObject).isKeyChange() && !(v_CheckRet = CallFlow.getHelpCheck().check(i_ExecObject)).get()) {
            return v_LastResult.setException(new RuntimeException(v_CheckRet.getParamStr()));
        }
        HashMap<String, Object> v_Context = io_Context == null ? new HashMap<String, Object>() : io_Context;
        CallFlow.clearError(v_Context);
        if (v_Context.get($WorkID) == null) {
            v_Context.put($WorkID, "CFW" + StringHelp.getUUID9n());
        }
        if (v_Context.get($NestingLevel) == null) {
            v_Context.put($NestingLevel, 0);
        }
        if (Help.isNull(i_ExecObject.getTreeIDs())) {
            CallFlow.getHelpExecute().calcTree(i_ExecObject);
        }
        if (i_Event != null) {
            v_Context.put($ExecuteEvent, i_Event);
        }
        String v_TreeID = i_ExecObject.getTreeIDs().iterator().next();
        if (i_Event != null && !i_Event.start(i_ExecObject, io_Context)) {
            return CallFlow.putError(io_Context, new ExecuteResult(CallFlow.getNestingLevel(v_Context), v_TreeID, i_ExecObject.getXJavaID(), "", null).setCancel());
        }
        try {
            ExecuteResult v_NodeResult = CallFlow.execute(i_ExecObject, v_Context, i_ExecObject.getTreeSuperID(v_TreeID), null, i_Event);
            v_LastResult.setPrevious(v_NodeResult);
            if (!CallFlow.getExecuteIsError(io_Context).booleanValue()) {
                if (CallFlow.isTrueReturn(v_Context)) {
                    ExecuteResult executeResult = v_LastResult.setResult(CallFlow.getReturnValue(v_Context));
                    return executeResult;
                }
                ExecuteResult executeResult = v_LastResult.setResult(v_NodeResult.getResult());
                return executeResult;
            }
            ExecuteResult v_ErrorResult = CallFlow.getErrorResult(v_Context);
            v_LastResult.setExecuteTreeID(v_ErrorResult.getExecuteTreeID());
            v_LastResult.setExecuteXID(v_ErrorResult.getExecuteXID());
            v_LastResult.setExecuteLogic(v_ErrorResult.getExecuteLogic());
            ExecuteResult executeResult = v_LastResult.setException(v_ErrorResult.getException());
            return executeResult;
        }
        finally {
            if (i_Event != null) {
                i_Event.finish(i_ExecObject, io_Context, v_LastResult);
            }
        }
    }

    private static ExecuteResult execute(IExecute i_ExecObject, Map<String, Object> io_Context, String i_SuperTreeID, ExecuteResult i_PreviousResult, IExecuteEvent i_Event) {
        if (i_Event != null && !i_Event.before(i_ExecObject, io_Context)) {
            ExecuteResult v_Result = new ExecuteResult(CallFlow.getNestingLevel(io_Context), i_ExecObject.getTreeID(i_SuperTreeID), i_ExecObject.getXJavaID(), "", i_PreviousResult).setCancel();
            if (i_PreviousResult == null) {
                io_Context.put($FirstExecuteResult, v_Result);
            }
            return CallFlow.putError(io_Context, v_Result);
        }
        ExecuteResult v_Result = i_ExecObject.execute(i_SuperTreeID, io_Context);
        v_Result.setElementType(i_ExecObject.getElementType());
        v_Result.setComment(i_ExecObject.getComment());
        if (i_PreviousResult == null) {
            io_Context.put($FirstExecuteResult, v_Result);
            ExecuteResult v_NestingBegin = (ExecuteResult)io_Context.remove($LastNestingBeginResult);
            if (v_NestingBegin != null) {
                v_Result.setPrevious(v_NestingBegin);
                v_NestingBegin.addNext(v_Result);
            } else {
                v_Result.setPrevious(null);
            }
        }
        if (!(i_ExecObject instanceof NestingConfig) && i_PreviousResult != null) {
            v_Result.setPrevious(i_PreviousResult);
        }
        io_Context.put($LastExecuteResult, v_Result);
        List<RouteItem> v_Nexts = null;
        if (v_Result.isSuccess()) {
            if (i_Event != null && !i_Event.success(i_ExecObject, io_Context, v_Result)) {
                return CallFlow.putError(io_Context, v_Result.setCancel());
            }
            if (i_ExecObject instanceof ConditionConfig) {
                v_Nexts = ((Boolean)v_Result.getResult()).booleanValue() ? i_ExecObject.getRoute().getSucceeds() : i_ExecObject.getRoute().getFaileds();
            } else if (i_ExecObject instanceof WaitConfig) {
                v_Nexts = ((Boolean)v_Result.getResult()).booleanValue() ? i_ExecObject.getRoute().getSucceeds() : i_ExecObject.getRoute().getFaileds();
            } else if (i_ExecObject instanceof CalculateConfig) {
                v_Nexts = Boolean.class.equals(v_Result.getResult().getClass()) ? (((Boolean)v_Result.getResult()).booleanValue() ? i_ExecObject.getRoute().getSucceeds() : i_ExecObject.getRoute().getFaileds()) : i_ExecObject.getRoute().getSucceeds();
            } else if (i_ExecObject instanceof SelfLoop) {
                Object v_RetValue = v_Result.getResult();
                if (v_RetValue instanceof Boolean) {
                    if (((Boolean)v_RetValue).booleanValue()) {
                        v_Nexts = ((SelfLoop)i_ExecObject).gatRoute().getSucceeds();
                    }
                } else {
                    v_Nexts = ((SelfLoop)i_ExecObject).gatRoute().getSucceeds();
                }
            } else {
                v_Nexts = i_ExecObject.getRoute().getSucceeds();
            }
        } else {
            if (i_Event != null && !i_Event.error(i_ExecObject, io_Context, v_Result)) {
                return v_Result;
            }
            v_Nexts = i_ExecObject instanceof SelfLoop ? ((SelfLoop)i_ExecObject).gatRoute().getExceptions() : i_ExecObject.getRoute().getExceptions();
            if (Help.isNull(v_Nexts)) {
                CallFlow.putError(io_Context, v_Result);
            } else {
                io_Context.put($ErrorResult, v_Result);
            }
        }
        if (i_Event != null && !i_Event.after(i_ExecObject, io_Context, v_Result)) {
            return CallFlow.putError(io_Context, v_Result.setCancel());
        }
        if (!Help.isNull(v_Nexts)) {
            for (RouteItem v_Next : v_Nexts) {
                Object v_RetValue;
                ExecuteResult v_NextResult = CallFlow.execute(v_Next.gatNext(), io_Context, i_ExecObject.getTreeID(i_SuperTreeID), v_Result, i_Event);
                v_Result.addNext(v_NextResult);
                if (CallFlow.getExecuteIsError(io_Context).booleanValue()) {
                    return v_Result;
                }
                if (CallFlow.isTrueReturn(io_Context)) {
                    return v_Result;
                }
                if (!(v_Next.gatNext() instanceof SelfLoop) || !((v_RetValue = v_NextResult.getResult()) instanceof Boolean) || !((Boolean)v_RetValue).booleanValue()) continue;
                break;
            }
            return v_Result;
        }
        return v_Result;
    }
}

