/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.berkeley;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.hy.common.berkeley.Berkeley;
import org.hy.common.berkeley.ClassInfo;

public class ClassBerkeley {
    private Berkeley dataDB;
    private Berkeley catalogDB;
    private Map<String, ClassInfo> catalogClasses;

    public ClassBerkeley(Berkeley i_Berkeley, String i_DatabaseName) {
        this.dataDB = i_Berkeley;
        this.catalogClasses = new Hashtable<String, ClassInfo>();
        this.catalogDB = new Berkeley();
        this.catalogDB.setEnvironmentConfig(this.dataDB.getEnvironmentConfig());
        this.catalogDB.setEnvironmentHome(this.dataDB.getEnvironmentHome());
        this.catalogDB.setEnvironment(this.dataDB.getEnvironment());
        this.catalogDB.setDatabaseConfig(this.dataDB.getDatabaseConfig());
        this.catalogDB.setDatabaseName(i_DatabaseName);
        this.catalogDB.setAutoCommit(this.dataDB.isAutoCommit());
        this.catalogDB.setDataEnCode(this.dataDB.getDataEnCode());
        try {
            this.catalogDB.setDatabase(this.catalogDB.getEnvironment().openDatabase(null, this.catalogDB.getDatabaseName(), this.catalogDB.getDatabaseConfig()));
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
    }

    public ClassInfo getClassInfo(String i_ClassName) {
        try {
            Class<?> v_Class = Class.forName(i_ClassName);
            return this.getClassInfo(v_Class);
        }
        catch (Exception exce) {
            exce.printStackTrace();
            return null;
        }
    }

    public synchronized ClassInfo getClassInfo(Class<? extends Serializable> i_Class) {
        String v_ClassName = i_Class.getName();
        ClassInfo v_ClassInfo = this.catalogClasses.get(v_ClassName);
        if (v_ClassInfo == null) {
            v_ClassInfo = new ClassInfo(this.catalogDB, i_Class);
            this.catalogClasses.put(v_ClassName, v_ClassInfo);
        }
        return v_ClassInfo;
    }

    public <T extends Serializable> boolean put(String i_Key, T i_ObjValue) {
        ClassInfo v_ClassInfo = this.getClassInfo(i_ObjValue.getClass());
        if (v_ClassInfo == null) {
            return false;
        }
        try {
            boolean v_Ret = this.dataDB.put(this.dataDB.toDBEntry(i_Key), v_ClassInfo.toDBEntry(i_ObjValue));
            if (v_Ret) {
                v_Ret = this.catalogDB.put(i_Key, i_ObjValue.getClass().getName());
                if (v_Ret) {
                    return true;
                }
                this.dataDB.delete(i_Key);
            }
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        return false;
    }

    public <T extends Serializable> boolean putNoOverwrite(String i_Key, T i_ObjValue) {
        ClassInfo v_ClassInfo = this.getClassInfo(i_ObjValue.getClass());
        if (v_ClassInfo == null) {
            return false;
        }
        try {
            boolean v_Ret = this.dataDB.putNoOverwrite(this.dataDB.toDBEntry(i_Key), v_ClassInfo.toDBEntry(i_ObjValue));
            if (v_Ret) {
                v_Ret = this.catalogDB.putNoOverwrite(i_Key, i_ObjValue.getClass().getName());
                if (v_Ret) {
                    return true;
                }
                this.dataDB.delete(i_Key);
            }
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        return false;
    }

    public <T extends Serializable> boolean putNoDupData(String i_Key, T i_ObjValue) {
        ClassInfo v_ClassInfo = this.getClassInfo(i_ObjValue.getClass());
        if (v_ClassInfo == null) {
            return false;
        }
        try {
            boolean v_Ret = this.dataDB.putNoDupData(this.dataDB.toDBEntry(i_Key), v_ClassInfo.toDBEntry(i_ObjValue));
            if (v_Ret) {
                v_Ret = this.catalogDB.putNoDupData(i_Key, i_ObjValue.getClass().getName());
                if (v_Ret) {
                    return true;
                }
                this.dataDB.delete(i_Key);
            }
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        return false;
    }

    public Object getObject(String i_Key) {
        DatabaseEntry v_DBEntry;
        ClassInfo v_ClassInfo;
        String v_ClassName = this.catalogDB.get(i_Key);
        if (v_ClassName != null && (v_ClassInfo = this.catalogClasses.get(v_ClassName)) != null && (v_DBEntry = this.dataDB.getDBEntry(i_Key)) != null) {
            return v_ClassInfo.getCatalogBinding().entryToObject(v_DBEntry);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ?> getObjects() {
        HashMap<String, Object> v_Ret = new HashMap<String, Object>();
        Cursor v_Cursor = null;
        DatabaseEntry v_Key = new DatabaseEntry();
        DatabaseEntry v_Value = new DatabaseEntry();
        try {
            v_Cursor = this.catalogDB.getDatabase().openCursor(null, null);
            while (v_Cursor.getNext(v_Key, v_Value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                DatabaseEntry v_DBEntry;
                ClassInfo v_ClassInfo;
                String v_ClassName = new String(v_Value.getData(), this.dataDB.getDataEnCode());
                if (null == v_ClassName || (v_ClassInfo = this.catalogClasses.get(v_ClassName)) == null || (v_DBEntry = this.dataDB.getDBEntry(v_Key)) == null) continue;
                v_Ret.put(new String(v_Key.getData(), this.dataDB.getDataEnCode()), v_ClassInfo.getCatalogBinding().entryToObject(v_DBEntry));
            }
        }
        catch (Exception exce) {
            try {
                exce.printStackTrace();
            }
            catch (Throwable throwable) {
                Berkeley.closeCursor(v_Cursor);
                throw throwable;
            }
            Berkeley.closeCursor(v_Cursor);
        }
        Berkeley.closeCursor(v_Cursor);
        return v_Ret;
    }

    public long getObjectCount() {
        return this.catalogDB.getCount();
    }

    public Berkeley getCatalogDB() {
        return this.catalogDB;
    }

    public long truncateObjectDB() {
        if (this.getObjectCount() > 0L) {
            this.catalogDB.truncateDB();
            return this.dataDB.truncateDB();
        }
        return 0L;
    }

    public void close() {
        if (this.catalogDB != null) {
            try {
                if (this.catalogDB.getDatabase() != null) {
                    this.catalogDB.getDatabase().close();
                }
                this.catalogDB.setDatabase(null);
            }
            catch (Exception exce) {
                exce.printStackTrace();
            }
        }
    }
}

