/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.berkeley;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.DatabaseEntry;
import java.io.Serializable;
import org.hy.common.berkeley.Berkeley;

public class ClassInfo
implements Comparable<ClassInfo> {
    private Class<? extends Serializable> classInfo;
    private StoredClassCatalog catalogStored;
    private EntryBinding<Object> catalogBinding;

    public ClassInfo(Berkeley i_Berkeley, Class<? extends Serializable> i_ClassInfo) {
        this.classInfo = i_ClassInfo;
        this.catalogStored = new StoredClassCatalog(i_Berkeley.getDatabase());
        this.catalogBinding = new SerialBinding((ClassCatalog)this.catalogStored, this.classInfo);
    }

    public <T extends Serializable> DatabaseEntry toDBEntry(T i_Obj) {
        DatabaseEntry v_Ret = new DatabaseEntry();
        this.catalogBinding.objectToEntry(i_Obj, v_Ret);
        return v_Ret;
    }

    public Class<? extends Serializable> getClassInfo() {
        return this.classInfo;
    }

    public StoredClassCatalog getCatalogStored() {
        return this.catalogStored;
    }

    public EntryBinding<Object> getCatalogBinding() {
        return this.catalogBinding;
    }

    public int hashCode() {
        return this.classInfo.hashCode();
    }

    public boolean equals(Object i_Other) {
        if (i_Other == null) {
            return false;
        }
        if (i_Other instanceof ClassInfo) {
            ClassInfo v_Other = (ClassInfo)i_Other;
            return this.classInfo.equals(v_Other.getClassInfo());
        }
        return false;
    }

    @Override
    public int compareTo(ClassInfo i_Other) {
        if (i_Other == null || i_Other.getClassInfo() == null) {
            return 1;
        }
        if (this.classInfo == i_Other.getClassInfo()) {
            return 0;
        }
        if (this.classInfo.equals(i_Other.getClassInfo())) {
            return 0;
        }
        return -1;
    }
}

