/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.berkeley;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hy.common.Help;
import org.hy.common.berkeley.ClassBerkeley;

public class Berkeley {
    private EnvironmentConfig environmentConfig;
    private String environmentHome;
    private Environment environment;
    private DatabaseConfig databaseConfig;
    private String databaseName;
    private Database database;
    private ClassBerkeley classBerkeley;
    private String dataEnCode = "UTF-8";
    private boolean autoCommit = true;

    public void open() {
        try {
            File v_envDir = new File(this.environmentHome);
            if (!v_envDir.exists()) {
                v_envDir.mkdirs();
            }
            this.environment = new Environment(new File(this.environmentHome), this.environmentConfig);
            this.database = this.environment.openDatabase(null, this.databaseName, this.databaseConfig);
            this.classBerkeley = new ClassBerkeley(this, this.databaseName + "_ClassCatalog");
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
    }

    public void cleanLog() {
        try {
            if (this.environment != null) {
                this.environment.cleanLog();
            }
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
    }

    public static void closeCursor(Cursor i_Cursor) {
        if (i_Cursor != null) {
            try {
                i_Cursor.close();
            }
            catch (Exception exce) {
                exce.printStackTrace();
            }
        }
    }

    public void close() {
        if (this.environment != null) {
            this.commit();
        }
        if (this.classBerkeley != null) {
            this.classBerkeley.close();
        }
        try {
            if (this.database != null) {
                this.database.close();
            }
            this.database = null;
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        this.cleanLog();
        try {
            if (this.environment != null) {
                this.environment.close();
            }
            this.environment = null;
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
    }

    public List<String> getDatabaseNames() {
        return this.environment.getDatabaseNames();
    }

    public long getCount() {
        return this.database.count();
    }

    public long getObjectCount() {
        return this.classBerkeley.getObjectCount();
    }

    public DatabaseEntry toDBEntry(String i_String) throws UnsupportedEncodingException {
        return new DatabaseEntry(i_String.getBytes(this.dataEnCode));
    }

    public void commit() {
        this.database.sync();
    }

    public <T extends Serializable> boolean put(String i_Key, T i_ObjValue) {
        return this.classBerkeley.put(i_Key, i_ObjValue);
    }

    public <T extends Serializable> boolean putNoOverwrite(String i_Key, T i_ObjValue) {
        return this.classBerkeley.putNoOverwrite(i_Key, i_ObjValue);
    }

    public <T extends Serializable> boolean putNoDupData(String i_Key, T i_ObjValue) {
        return this.classBerkeley.putNoDupData(i_Key, i_ObjValue);
    }

    public boolean put(String i_Key, String i_Value) {
        try {
            return this.put(this.toDBEntry(i_Key), this.toDBEntry(Help.NVL((String)i_Value)));
        }
        catch (Exception exce) {
            exce.printStackTrace();
            return false;
        }
    }

    public boolean putNoOverwrite(String i_Key, String i_Value) {
        try {
            return this.putNoOverwrite(this.toDBEntry(i_Key), this.toDBEntry(Help.NVL((String)i_Value)));
        }
        catch (Exception exce) {
            exce.printStackTrace();
            return false;
        }
    }

    public boolean putNoDupData(String i_Key, String i_Value) {
        try {
            return this.putNoDupData(this.toDBEntry(i_Key), this.toDBEntry(Help.NVL((String)i_Value)));
        }
        catch (Exception exce) {
            exce.printStackTrace();
            return false;
        }
    }

    public boolean put(DatabaseEntry i_Key, DatabaseEntry i_Value) {
        OperationStatus v_OperationStatus = this.database.put(null, i_Key, i_Value);
        if (v_OperationStatus == OperationStatus.SUCCESS) {
            if (this.autoCommit) {
                this.commit();
            }
            return true;
        }
        return false;
    }

    public boolean putNoOverwrite(DatabaseEntry i_Key, DatabaseEntry i_Value) {
        OperationStatus v_OperationStatus = this.database.putNoOverwrite(null, i_Key, i_Value);
        if (v_OperationStatus == OperationStatus.SUCCESS) {
            if (this.autoCommit) {
                this.commit();
            }
            return true;
        }
        return v_OperationStatus == OperationStatus.KEYEXIST;
    }

    public boolean putNoDupData(DatabaseEntry i_Key, DatabaseEntry i_Value) {
        OperationStatus v_OperationStatus = this.database.putNoDupData(null, i_Key, i_Value);
        if (v_OperationStatus == OperationStatus.SUCCESS) {
            if (this.autoCommit) {
                this.commit();
            }
            return true;
        }
        return false;
    }

    public Object getObject(String i_Key) {
        return this.classBerkeley.getObject(i_Key);
    }

    public Map<String, ?> getObjects() {
        return this.classBerkeley.getObjects();
    }

    public String get(String i_Key) {
        DatabaseEntry v_Value = this.getDBEntry(i_Key);
        if (v_Value != null) {
            try {
                return new String(v_Value.getData(), this.dataEnCode);
            }
            catch (Exception exce) {
                exce.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> gets() {
        HashMap<String, String> v_Ret = new HashMap<String, String>();
        Cursor v_Cursor = null;
        DatabaseEntry v_Key = new DatabaseEntry();
        DatabaseEntry v_Value = new DatabaseEntry();
        try {
            v_Cursor = this.database.openCursor(null, null);
            while (v_Cursor.getNext(v_Key, v_Value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                v_Ret.put(new String(v_Key.getData(), this.dataEnCode), new String(v_Value.getData(), this.dataEnCode));
            }
        }
        catch (Exception exce) {
            try {
                exce.printStackTrace();
            }
            catch (Throwable throwable) {
                Berkeley.closeCursor(v_Cursor);
                throw throwable;
            }
            Berkeley.closeCursor(v_Cursor);
        }
        Berkeley.closeCursor(v_Cursor);
        return v_Ret;
    }

    public DatabaseEntry getDBEntry(String i_Key) {
        DatabaseEntry v_Value = new DatabaseEntry();
        OperationStatus v_OperationStatus = null;
        try {
            v_OperationStatus = this.database.get(null, this.toDBEntry(i_Key), v_Value, LockMode.DEFAULT);
            if (v_OperationStatus != null && v_OperationStatus == OperationStatus.SUCCESS) {
                return v_Value;
            }
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        return null;
    }

    public DatabaseEntry getDBEntry(DatabaseEntry i_Key) {
        DatabaseEntry v_Value = new DatabaseEntry();
        OperationStatus v_OperationStatus = this.database.get(null, i_Key, v_Value, LockMode.DEFAULT);
        if (v_OperationStatus != null && v_OperationStatus == OperationStatus.SUCCESS) {
            return v_Value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DatabaseEntry> getDBEntrys() {
        HashMap<String, DatabaseEntry> v_Ret = new HashMap<String, DatabaseEntry>();
        Cursor v_Cursor = null;
        DatabaseEntry v_Key = new DatabaseEntry();
        DatabaseEntry v_Value = new DatabaseEntry();
        try {
            v_Cursor = this.database.openCursor(null, null);
            while (v_Cursor.getNext(v_Key, v_Value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                v_Ret.put(new String(v_Key.getData(), this.dataEnCode), v_Value);
            }
        }
        catch (Exception exce) {
            try {
                exce.printStackTrace();
            }
            catch (Throwable throwable) {
                Berkeley.closeCursor(v_Cursor);
                throw throwable;
            }
            Berkeley.closeCursor(v_Cursor);
        }
        Berkeley.closeCursor(v_Cursor);
        return v_Ret;
    }

    public boolean delete(String i_Key) {
        OperationStatus v_OperationStatus = null;
        try {
            v_OperationStatus = this.database.delete(null, this.toDBEntry(i_Key));
            if (v_OperationStatus == OperationStatus.SUCCESS) {
                if (this.autoCommit) {
                    this.commit();
                }
                this.cleanLog();
                return true;
            }
            return false;
        }
        catch (Exception exce) {
            exce.printStackTrace();
            return false;
        }
    }

    public void deletes() {
        Map<String, String> v_Datas = this.gets();
        if (!Help.isNull(v_Datas)) {
            for (String v_Key : v_Datas.keySet()) {
                this.delete(v_Key);
            }
            this.environment.sync();
            this.cleanLog();
        }
    }

    public long truncateDB() {
        if (this.getCount() > 0L) {
            long v_Ret = this.environment.truncateDatabase(null, this.database.getDatabaseName(), true);
            this.cleanLog();
            return v_Ret;
        }
        return 0L;
    }

    public long truncateObjectDB() {
        return this.classBerkeley.truncateObjectDB();
    }

    public EnvironmentConfig getEnvironmentConfig() {
        return this.environmentConfig;
    }

    public void setEnvironmentConfig(EnvironmentConfig environmentConfig) {
        this.environmentConfig = environmentConfig;
    }

    public String getEnvironmentHome() {
        return this.environmentHome;
    }

    public void setEnvironmentHome(String environmentHome) {
        this.environmentHome = environmentHome;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public DatabaseConfig getDatabaseConfig() {
        return this.databaseConfig;
    }

    public void setDatabaseConfig(DatabaseConfig databaseConfig) {
        this.databaseConfig = databaseConfig;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public String getDataEnCode() {
        return this.dataEnCode;
    }

    public void setDataEnCode(String dataEnCode) {
        this.dataEnCode = dataEnCode;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    protected void finalize() {
        this.close();
    }
}

