/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.web.entity;

import cn.omisheep.web.entity.ResultCode;
import com.fasterxml.jackson.annotation.JsonInclude;

public class Result<E> {
    private int code;
    private String message;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private E data;
    public static final ResultCode SUCCESS = ResultCode.info(100, "SUCCESS");
    public static final ResultCode OK = ResultCode.info(100, "OK");
    public static final ResultCode FAIL = ResultCode.info(-100, "FAIL");
    public static final ResultCode SERVER_ERROR = ResultCode.info(-9999, "SERVER ERROR");

    protected Result(ResultCode resultCode, E data) {
        this.code = resultCode.code;
        this.message = resultCode.message;
        this.data = data;
    }

    protected Result(ResultCode resultCode) {
        this(resultCode, null);
    }

    public static <E> Result<E> of(ResultCode resultCode) {
        return new Result<Object>(resultCode, null);
    }

    public static <E> Result<E> of(int code, String message, E data) {
        return new Result<E>(ResultCode.info(code, message), data);
    }

    public static <E> Result<E> of(int code, String message) {
        return new Result<Object>(ResultCode.info(code, message), null);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public E getData() {
        return this.data;
    }

    public void setData(E data) {
        this.data = data;
    }

    public Result() {
    }

    protected Result(int code, String message, E data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public String toString() {
        return "Result{code=" + this.code + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
    }
}

