/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.web.entity;

import cn.omisheep.web.entity.ICode;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ICodeCache {
    private static final HashMap<Class<?>, CodeMeta> cache = new HashMap();

    private static CodeMeta getMeta(Class<?> clz) {
        return cache.computeIfAbsent(clz, CodeMeta::new);
    }

    public static int getCode(int defaultValue, Object target) {
        return (Integer)ICodeCache.getMeta(target.getClass()).code.get(defaultValue, target);
    }

    public static String getMessage(String defaultValue, Object target) {
        return (String)ICodeCache.getMeta(target.getClass()).message.get(defaultValue, target);
    }

    public static class CodeMeta {
        private DelegateMeta code = new DelegateMeta();
        private DelegateMeta message = new DelegateMeta();

        public CodeMeta(Class<?> clz) {
            for (Field field : clz.getDeclaredFields()) {
                if (field.getAnnotation(ICode.Code.class) == null && !field.getName().equals("code")) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                this.code.field = field;
                break;
            }
            if (this.code.field == null) {
                for (AccessibleObject accessibleObject : clz.getMethods()) {
                    if (((Method)accessibleObject).getAnnotation(ICode.Code.class) == null && !((Method)accessibleObject).getName().equals("getCode")) continue;
                    if (!accessibleObject.isAccessible()) {
                        ((Method)accessibleObject).setAccessible(true);
                    }
                    this.code.method = (Method)accessibleObject;
                    break;
                }
            }
            for (AccessibleObject accessibleObject : clz.getDeclaredFields()) {
                if (((Field)accessibleObject).getAnnotation(ICode.Message.class) == null && !((Field)accessibleObject).getName().equals("message")) continue;
                if (!accessibleObject.isAccessible()) {
                    ((Field)accessibleObject).setAccessible(true);
                }
                this.message.field = (Field)accessibleObject;
                break;
            }
            if (this.message.field == null) {
                for (AccessibleObject accessibleObject : clz.getMethods()) {
                    if (((Method)accessibleObject).getAnnotation(ICode.Message.class) == null && !((Method)accessibleObject).getName().equals("getMessage")) continue;
                    if (!accessibleObject.isAccessible()) {
                        ((Method)accessibleObject).setAccessible(true);
                    }
                    this.message.method = (Method)accessibleObject;
                    break;
                }
            }
        }

        public DelegateMeta getCode() {
            return this.code;
        }

        public CodeMeta setCode(DelegateMeta code) {
            this.code = code;
            return this;
        }

        public DelegateMeta getMessage() {
            return this.message;
        }

        public CodeMeta setMessage(DelegateMeta message) {
            this.message = message;
            return this;
        }
    }

    public static class DelegateMeta {
        private Field field;
        private Method method;

        public DelegateMeta setField(Field field) {
            this.field = field;
            return this;
        }

        public DelegateMeta setMethod(Method method) {
            this.method = method;
            return this;
        }

        public Object get(Object defaultValue, Object target) {
            try {
                if (this.field != null) {
                    if (!this.field.isAccessible()) {
                        this.field.setAccessible(true);
                    }
                    return this.field.get(target);
                }
                if (this.method != null) {
                    if (!this.method.isAccessible()) {
                        this.method.setAccessible(true);
                    }
                    return this.method.invoke(target, new Object[0]);
                }
                return defaultValue;
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
    }
}

