package cn.omisheep.web.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.function.Supplier;

/**
 * @author zhouxinchen
 * @since 1.0.5
 */
public class FiledUtils {

    @SuppressWarnings("unchecked")
    public static <E> E read(String name,
                             Object target,
                             Supplier<E> orGet) {
        try {
            Field field = target.getClass().getDeclaredField(name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return (E) field.get(target);
        } catch (NoSuchFieldException | IllegalAccessException e) {
            e.printStackTrace();
            return orGet.get();
        }
    }

    @SuppressWarnings("unchecked")
    public static <E> E read(Class<? extends Annotation> annotation,
                             Object target,
                             Supplier<E> orGet) {
        for (Field field : target.getClass().getDeclaredFields()) {
            if (field.getAnnotation(annotation) != null) {
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    return (E) field.get(target);
                } catch (IllegalAccessException e) {
                    return orGet.get();
                }
            }
        }
        return orGet.get();
    }

}
