package cn.omisheep.web.entity;

import com.fasterxml.jackson.annotation.JsonInclude;

import static cn.omisheep.web.entity.ResultCode.info;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * <strong>web返回体</strong>
 *
 * @author zhouxinchen[1269670415@qq.com]
 * @version 1.0.8
 * @since 1.0.0
 */
public class Result<E> {

    private int    code;
    private String message;
    @JsonInclude(NON_NULL)
    private E      data;

    public static final ResultCode SUCCESS = info(100, "SUCCESS");
    public static final ResultCode OK      = info(100, "OK");

    public static final ResultCode FAIL = info(-100, "FAIL");

    public static final ResultCode SERVER_ERROR = info(-9999, "SERVER ERROR");

    protected Result(ResultCode resultCode,
                     E data) {
        this.code    = resultCode.code;
        this.message = resultCode.message;
        this.data    = data;
    }

    protected Result(ResultCode resultCode) {
        this(resultCode, null);
    }

    public static <E> Result<E> of(ResultCode resultCode) {
        return new Result<>(resultCode, null);
    }

    public static <E> Result<E> of(int code,
                                   String message,
                                   E data) {
        return new Result<>(info(code, message), data);
    }

    public static <E> Result<E> of(int code,
                                   String message) {
        return new Result<>(info(code, message), null);
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public E getData() {
        return data;
    }

    public void setData(E data) {
        this.data = data;
    }

    public Result() {
    }

    protected Result(int code,
                     String message,
                     E data) {
        this.code    = code;
        this.message = message;
        this.data    = data;
    }

    @Override
    public String toString() {
        return "Result{" + "code=" + code +
                ", message='" + message + '\'' +
                ", data=" + data +
                '}';
    }
}
