package cn.omisheep.web.entity;

import com.fasterxml.jackson.annotation.JsonInclude;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * @author zhouxinchen
 * @since 1.0.5
 */
public class ResponseResult<E> {

    private int    code;
    private String message;

    @JsonInclude(NON_NULL)
    private E data;

    protected ResponseResult() {
    }

    protected ResponseResult(int code,
                             String message,
                             E data) {
        this.code    = code;
        this.message = message;
        this.data    = data;
    }

    protected ResponseResult(int code,
                             String message) {
        this.code    = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public E getData() {
        return data;
    }

    @Override
    public String toString() {
        return "ResponseResult{" + "code=" + code +
                ", message='" + message + '\'' +
                ", data=" + data +
                '}';
    }
}
