package cn.omisheep.web.entity;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import static cn.omisheep.web.utils.FiledUtils.read;

/**
 * @author zhouxinchen
 * @since 1.0.5
 */
public interface ICode {

    default int getCode() {
        return read(Code.class, this, () ->
                read("code", this, () -> Integer.MIN_VALUE)
        );
    }

    default String getMessage() {
        return read(Message.class, this, () ->
                read("message", this, () -> null)
        );
    }

    @Target(ElementType.FIELD)
    @Retention(RetentionPolicy.RUNTIME)
    @interface Code {
    }

    @Target(ElementType.FIELD)
    @Retention(RetentionPolicy.RUNTIME)
    @interface Message {
    }

}
