/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.web.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpUtils {
    public static final ThreadLocal<HttpServletRequest> request = new ThreadLocal();

    public static HttpServletRequest getCurrentRequest() {
        try {
            if (request.get() == null) {
                request.set(HttpUtils.getCurrentRequestAttributes().getRequest());
            }
            return request.get();
        }
        catch (Exception e) {
            return request.get();
        }
    }

    public static HttpServletResponse getCurrentResponse() {
        return HttpUtils.getCurrentRequestAttributes().getResponse();
    }

    public static ServletRequestAttributes getCurrentRequestAttributes() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        RequestContextHolder.setRequestAttributes((RequestAttributes)servletRequestAttributes, (boolean)true);
        return servletRequestAttributes;
    }

    public static Cookie readSingleCookieInRequestByName(String name) {
        HttpServletRequest request = HttpUtils.getCurrentRequest();
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        return Arrays.stream(cookies).filter(cookie -> name.equals(cookie.getName())).findFirst().orElse(null);
    }

    public static Map<String, String> getHeaders(HttpServletRequest request) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (request == null) {
            return map;
        }
        Enumeration enumeration = request.getHeaderNames();
        if (enumeration == null) {
            return map;
        }
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            map.put(key, request.getHeader(key));
        }
        return map;
    }

    public static Map<String, String> getCurrentRequestHeaders() {
        return HttpUtils.getHeaders(HttpUtils.getCurrentRequest());
    }

    public static void returnResponse(HttpStatus status, Object object) throws IOException {
        HttpUtils.returnResponse(status.value(), object);
    }

    public static void returnResponse(int status, Object object) throws IOException {
        HttpServletResponse response = HttpUtils.getCurrentResponse();
        response.setStatus(status);
        response.getWriter().write(JSONObject.toJSONString((Object)object));
        response.setContentType("application/json");
    }
}

