/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.web.entity;

import cn.omisheep.web.entity.ResultCode;
import com.fasterxml.jackson.annotation.JsonInclude;

public class Result {
    int code;
    String message;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    Object data;
    public static final ResultCode SUCCESS = ResultCode.info(100, "SUCCESS");
    public static final ResultCode OK = ResultCode.info(100, "OK");
    public static final ResultCode FAIL = ResultCode.info(-100, "FAIL");
    public static final ResultCode SERVER_ERROR = ResultCode.info(-9999, "SERVER ERROR");

    protected Result(ResultCode resultCode, Object data) {
        this.code = resultCode.code;
        this.message = resultCode.message;
        this.data = data;
    }

    protected Result(ResultCode resultCode) {
        this(resultCode, null);
    }

    public static Result of(ResultCode resultCode) {
        return new Result(resultCode, null);
    }

    public static Result of(int code, String message, Object data) {
        return new Result(ResultCode.info(code, message), data);
    }

    public static Result of(int code, String message) {
        return new Result(ResultCode.info(code, message), null);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Result() {
    }

    protected Result(int code, String message, Object data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }
}

