package cn.omisheep.web.entity;

import com.fasterxml.jackson.annotation.JsonInclude;

import static cn.omisheep.web.entity.ResultCode.info;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * <strong>web返回体</strong>
 * <p>
 * <p>
 * 如果需要自定义可参考以下：
 * <pre>
 * import static cn.omisheep.commons.web.entity.ResultCode.info;
 *
 * public interface CustomResult extends Result {
 *     ResultCode SUCCESS = info(100, "成功");
 *     ...
 * }
 *
 * Or:
 * public interface CustomResult {
 *     ResultCode SUCCESS = info(200, "成功");
 *     ...
 * }
 *
 * ...
 * System.out.println(CustomResult.SUCCESS.data());
 * System.out.println(Res.SUCCESS.data());
 * </pre>
 *
 * @author zhouxinchen[1269670415@qq.com]
 * @version 1.0.0
 * @since 1.0.0
 */
public class Result {
    int code;
    String message;

    @JsonInclude(NON_NULL)
    Object data;

    public static final ResultCode SUCCESS = info(100, "SUCCESS");
    public static final ResultCode OK = info(100, "OK");

    public static final ResultCode FAIL = info(-100, "FAIL");

    public static final ResultCode SERVER_ERROR = info(-9999, "SERVER ERROR");

    protected Result(ResultCode resultCode, Object data) {
        this.code = resultCode.code;
        this.message = resultCode.message;
        this.data = data;
    }

    protected Result(ResultCode resultCode) {
        this(resultCode, null);
    }

    public static Result of(ResultCode resultCode) {
        return new Result(resultCode, null);
    }

    public static Result of(int code, String message, Object data) {
        return new Result(info(code, message), data);
    }

    public static Result of(int code, String message) {
        return new Result(info(code, message), null);
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Result() {
    }

    protected Result(int code, String message, Object data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }
}
