/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util.web.ua;

import cn.omisheep.commons.util.web.ua.Browser;
import cn.omisheep.commons.util.web.ua.OS;
import cn.omisheep.commons.util.web.ua.Platform;
import cn.omisheep.commons.util.web.ua.UserAgent;
import org.apache.commons.lang.StringUtils;

public class UserAgentParser {
    private UserAgentParser() {
        throw new UnsupportedOperationException();
    }

    public static UserAgent parse(String userAgentString) {
        if (StringUtils.isBlank((String)userAgentString)) {
            return new UserAgent().setUserAgentString(userAgentString).setPlatform(Platform.UNKNOWN).setOs(OS.UNKNOWN).setBrowser(Browser.UNKNOWN);
        }
        UserAgent userAgent = new UserAgent().setUserAgentString(userAgentString);
        Browser browser = UserAgentParser.parseBrowser(userAgentString);
        userAgent.setBrowser(browser);
        userAgent.setVersion(browser.getVersion(userAgentString));
        OS os = UserAgentParser.parseOS(userAgentString);
        userAgent.setOs(os);
        Platform platform = UserAgentParser.parsePlatform(userAgentString);
        userAgent.setPlatform(platform);
        return userAgent;
    }

    private static Browser parseBrowser(String userAgentString) {
        for (Browser browser : Browser.values()) {
            if (!browser.isMatch(userAgentString)) continue;
            return browser;
        }
        return Browser.UNKNOWN;
    }

    private static OS parseOS(String userAgentString) {
        for (OS os : OS.values()) {
            if (!os.isMatch(userAgentString)) continue;
            return os;
        }
        return OS.UNKNOWN;
    }

    private static Platform parsePlatform(String userAgentString) {
        for (Platform platform : Platform.values()) {
            if (!platform.isMatch(userAgentString)) continue;
            return platform;
        }
        return Platform.UNKNOWN;
    }
}

