/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util.web.ua;

import cn.omisheep.commons.util.web.ua.Browser;
import cn.omisheep.commons.util.web.ua.OS;
import cn.omisheep.commons.util.web.ua.Platform;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class UserAgent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Browser browser;
    private String version;
    private Platform platform;
    private OS os;
    @JsonIgnore
    private String userAgentString;

    public boolean isMobile() {
        return this.platform.isMobile() || this.browser.isMobile();
    }

    public boolean isPC() {
        return this.platform.isPC();
    }

    public String getOsVersion() {
        if (StringUtils.isBlank((String)this.userAgentString)) {
            return null;
        }
        return this.browser.getVersion(this.userAgentString);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public UserAgent setBrowser(Browser browser) {
        this.browser = browser;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public UserAgent setVersion(String version) {
        this.version = version;
        return this;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public UserAgent setPlatform(Platform platform) {
        this.platform = platform;
        return this;
    }

    public OS getOs() {
        return this.os;
    }

    public UserAgent setOs(OS os) {
        this.os = os;
        return this;
    }

    public String getUserAgentString() {
        return this.userAgentString;
    }

    public UserAgent setUserAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
        return this;
    }
}

