/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util.web.ua;

import cn.omisheep.commons.util.web.ua.MatchUtils;
import cn.omisheep.commons.util.web.ua.UserAgentInfo;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public enum Platform implements UserAgentInfo
{
    UNKNOWN("Unknown", null),
    IPHONE("iPhone", "iphone"),
    IPOD("iPod", "ipod"),
    IPAD("iPad", "ipad"),
    ANDROID("Android", "android"),
    GOOGLE_TV("GoogleTV", "googletv"),
    WINDOWS_PHONE("Windows Phone", "windows (ce|phone|mobile)( os)?"),
    HTC_FLYER("htcFlyer", "htc_flyer"),
    SYMBIAN("Symbian", "symbian(os)?"),
    BLACKBERRY("Blackberry", "blackberry"),
    WINDOWS("Windows", "windows"),
    MAC("Mac", "(macintosh|darwin)"),
    LINUX("Linux", "linux"),
    WII("Wii", "wii"),
    PLAYSTATION("Playstation", "playstation"),
    JAVA("Java", "java");

    public static final List<Platform> mobilePlatforms;
    public static final List<Platform> desktopPlatforms;
    private final String name;
    private final Pattern regex;

    private Platform(String name, String regex) {
        this.name = name;
        this.regex = regex == null ? null : Pattern.compile(regex, 2);
    }

    public boolean isMobile() {
        return mobilePlatforms.contains(this);
    }

    public boolean isPC() {
        return desktopPlatforms.contains(this);
    }

    public boolean isIPhoneOrIPod() {
        return this.equals(IPHONE) || this.equals(IPOD);
    }

    public boolean isIPad() {
        return this.equals(IPAD);
    }

    public boolean isIos() {
        return this.isIPhoneOrIPod() || this.isIPad();
    }

    public boolean isAndroid() {
        return this.equals(ANDROID) || this.equals(GOOGLE_TV);
    }

    @Override
    public String getName() {
        return this.name;
    }

    boolean isMatch(String content) {
        return MatchUtils.match(this.regex, content);
    }

    static {
        mobilePlatforms = Arrays.asList(WINDOWS_PHONE, IPAD, IPOD, IPHONE, ANDROID, GOOGLE_TV, HTC_FLYER, SYMBIAN, BLACKBERRY);
        desktopPlatforms = Arrays.asList(WINDOWS, MAC, LINUX, WII, PLAYSTATION, JAVA);
    }
}

