/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util.web.ua;

import cn.omisheep.commons.util.web.ua.MatchUtils;
import cn.omisheep.commons.util.web.ua.UserAgentInfo;
import java.util.regex.Pattern;

public enum Browser implements UserAgentInfo
{
    UNKNOWN("Unknown", null, null),
    WXWORK("wxwork", "wxwork", "wxwork\\/([\\d\\w\\.\\-]+)"),
    MICRO_MESSENGER("MicroMessenger", "MicroMessenger", "[\\/ ]([\\d\\w\\.\\-]+)"),
    MINI_PROGRAM("miniProgram", "miniProgram", "[\\/ ]([\\d\\w\\.\\-]+)"),
    QQ_BROWSER("QQBrowser", "MQQBrowser", "MQQBrowser\\/([\\d\\w\\.\\-]+)"),
    DING_TALK("DingTalk", "DingTalk", "AliApp\\(DingTalk\\/([\\d\\w\\.\\-]+)\\)"),
    ALIPAY("Alipay", "AlipayClient", "AliApp\\(AP\\/([\\d\\w\\.\\-]+)\\)"),
    TAOBAO("Taobao", "taobao", "AliApp\\(TB\\/([\\d\\w\\.\\-]+)\\)"),
    UC_BROWSER("UCBrowser", "UC?Browser", "UC?Browser\\/([\\d\\w\\.\\-]+)"),
    QUARK("Quark", "Quark", "[\\/ ]([\\d\\w\\.\\-]+)"),
    LENOVO("Lenovo", "SLBrowser", "SLBrowser/([\\d\\w\\.\\-]+)"),
    MS_EDGE("MSEdge", "Edge|Edg", "(?:edge|Edg|EdgA)\\/([\\d\\w\\.\\-]+)"),
    CHROME("Chrome", "chrome", "[\\/ ]([\\d\\w\\.\\-]+)"),
    FIREFOX("Firefox", "firefox", "[\\/ ]([\\d\\w\\.\\-]+)"),
    IE_MOBILE("IEMobile", "iemobile", "[\\/ ]([\\d\\w\\.\\-]+)"),
    ANDROID_BROWSER("Android Browser", "android", "version\\/([\\d\\w\\.\\-]+)"),
    SAFARI("Safari", "safari", "version\\/([\\d\\w\\.\\-]+)"),
    OPERA("Opera", "opera", "[\\/ ]([\\d\\w\\.\\-]+)"),
    KONQUEROR("Konqueror", "konqueror", "[\\/ ]([\\d\\w\\.\\-]+)"),
    PS3r("PS3", "playstation 3", "([\\d\\w\\.\\-]+)\\)\\s*$"),
    PSP("PSP", "playstation portable", "([\\d\\w\\.\\-]+)\\)?\\s*$"),
    LOTUS("Lotus", "lotus.notes", "Lotus-Notes\\/([\\w.]+)"),
    THUNDERBIRD("Thunderbird", "thunderbird", "[\\/ ]([\\d\\w\\.\\-]+)"),
    NETSCAPE("Netscape", "netscape", "[\\/ ]([\\d\\w\\.\\-]+)"),
    SEAMONKEY("Seamonkey", "seamonkey", "[\\/ ]([\\d\\w\\.\\-]+)"),
    OUTLOOK("Outlook", "microsoft.outlook", "[\\/ ]([\\d\\w\\.\\-]+)"),
    EVOLUTION("Evolution", "evolution", "[\\/ ]([\\d\\w\\.\\-]+)"),
    MSIE("MSIE", "msie", "msie ([\\d\\w\\.\\-]+)"),
    MSIE11("MSIE11", "rv:11", "rv:([\\d\\w\\.\\-]+)"),
    GABBLE("Gabble", "Gabble", "[\\/ ]([\\d\\w\\.\\-]+)"),
    YAMMER_DESKTOP("Yammer Desktop", "AdobeAir", "([\\d\\w\\.\\-]+)\\/Yammer"),
    YAMMER_MOBILE("Yammer Mobile", "Yammer[\\s]+([\\d\\w\\.\\-]+)", "Yammer[\\s]+([\\d\\w\\.\\-]+)"),
    APACHE_HTTP_CLIENT("Apache HTTP Client", "Apache\\\\-HttpClient", "Apache\\-HttpClient\\/([\\d\\w\\.\\-]+)"),
    BLACK_BERRY("BlackBerry", "BlackBerry", "BlackBerry[\\d]+\\/([\\d\\w\\.\\-]+)");

    private final String name;
    private final Pattern regex;
    private Pattern versionPattern;

    private Browser(String name, String regex, String versionRegex) {
        this.name = name;
        Pattern pattern = this.regex = regex == null ? null : Pattern.compile(regex, 2);
        if ("[\\/ ]([\\d\\w\\.\\-]+)".equals(versionRegex)) {
            versionRegex = name + versionRegex;
        }
        if (null != versionRegex) {
            this.versionPattern = Pattern.compile(versionRegex, 2);
        }
    }

    public String getVersion(String userAgentString) {
        if (this.isUnknown()) {
            return null;
        }
        return MatchUtils.group(this.versionPattern, userAgentString, 1);
    }

    public boolean isMobile() {
        String name = this.getName();
        return "PSP".equals(name) || "Yammer Mobile".equals(name) || "Android Browser".equals(name) || "IEMobile".equals(name) || "MicroMessenger".equals(name) || "miniProgram".equals(name) || "DingTalk".equals(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    boolean isMatch(String content) {
        return MatchUtils.match(this.regex, content);
    }
}

