/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;

public class JSONUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JSONUtils() {
        throw new UnsupportedOperationException();
    }

    public static String toJSONString(Object o) {
        try {
            return OBJECT_MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public static String toPrettyJSONString(Object o) {
        try {
            return OBJECT_MAPPER.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public static Map<String, Object> parseJSON(String json) {
        try {
            return (Map)OBJECT_MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parseJSON(String json, Class<T> cls) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, cls);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parseJSON(String json, TypeReference<T> tTypeReference) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, tTypeReference);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String toPrettyJSON(String json) {
        try {
            return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)JSONUtils.parseJSON(json, Map.class));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "";
        }
    }

    static {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        OBJECT_MAPPER.setDateFormat((DateFormat)dateFormat);
    }
}

