/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util.charset.detector;

import cn.omisheep.commons.util.charset.detector.jchardet.nsDetector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class CharsetDetector {
    private CharsetDetector() {
        throw new UnsupportedOperationException();
    }

    public static Charset detectStr(String content) throws IOException {
        return CharsetDetector.detect(new ByteArrayInputStream(content.getBytes()));
    }

    public static Charset detect(String path) throws IOException {
        return CharsetDetector.detect(new File(path));
    }

    public static Charset detect(File file) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            Charset charset = CharsetDetector.detect(stream);
            return charset;
        }
    }

    public static Charset detect(InputStream inputStream) throws IOException {
        return CharsetDetector.detect(inputStream, 0);
    }

    public static Charset detect(InputStream inputStream, int langFlag) throws IOException {
        int len;
        boolean[] found = new boolean[]{false};
        String[] charset = new String[1];
        nsDetector det = new nsDetector(langFlag);
        det.Init(a -> {
            found[0] = true;
            charset[0] = a;
        });
        byte[] buf = new byte[1024];
        boolean done = false;
        boolean isAscii = true;
        while ((len = inputStream.read(buf, 0, buf.length)) != -1) {
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (isAscii || done) continue;
            done = det.DoIt(buf, len, false);
        }
        det.DataEnd();
        if (isAscii) {
            charset[0] = "ASCII";
            found[0] = true;
        }
        if (!found[0]) {
            String[] prob = det.getProbableCharsets();
            charset[0] = prob[0];
        }
        return Charset.forName(charset[0]);
    }
}

