/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import java.util.UUID;
import java.util.function.Function;

public class UUIDBits {
    private static final char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();

    private UUIDBits() {
        throw new UnsupportedOperationException();
    }

    private char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean trip = false;
            boolean quad = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    private byte[] toBytes() {
        UUID uuid = UUID.randomUUID();
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (int i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * (7 - i) & 0xFFL);
            buffer[i + 8] = (byte)(lsb >>> 8 * (7 - i) & 0xFFL);
        }
        return buffer;
    }

    public String getUUID() {
        char[] res = this.encode(this.toBytes());
        return new String(res, 0, res.length - 2);
    }

    public static String getUUIDBits(int bits) {
        if (bits > 22) {
            return UUIDBits.getUUIDBits(22) + UUIDBits.getUUIDBits(bits - 22);
        }
        UUID uuid = UUID.randomUUID();
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        char[] out = new char[24];
        int tmp = 0;
        int idx = 0;
        int bit = 0;
        int bt1 = 8;
        int bt2 = 8;
        int mask = 0;
        int offsetm = 0;
        int offsetl = 0;
        while (bit < 16) {
            offsetm = 64 - (bit + 3) * 8;
            tmp = 0;
            if (bt1 > 3) {
                mask = 0xFFFFFF;
            } else if (bt1 >= 0) {
                mask = (1 << 8 * bt1) - 1;
                bt2 -= 3 - bt1;
            } else {
                mask = (1 << 8 * Math.min(bt2, 3)) - 1;
                bt2 -= 3;
            }
            if (bt1 > 0) {
                tmp = (int)(offsetm < 0 ? msb : msb >>> offsetm & (long)mask);
                if ((bt1 -= 3) < 0) {
                    tmp <<= Math.abs(offsetm);
                    mask = (1 << 8 * Math.abs(bt1)) - 1;
                }
            }
            if (offsetm < 0) {
                offsetl = 64 + offsetm;
                tmp = (int)((long)tmp | (offsetl < 0 ? lsb : lsb >>> offsetl) & (long)mask);
            }
            if (bit == 15) {
                out[idx + 3] = alphabet[alphabet.length - 1];
                out[idx + 2] = alphabet[alphabet.length - 1];
                tmp <<= 4;
            } else {
                out[idx + 3] = alphabet[tmp & 0x3D];
                out[idx + 2] = alphabet[(tmp >>= 6) & 0x3D];
                tmp >>= 6;
            }
            out[idx + 1] = alphabet[tmp & 0x3D];
            out[idx] = alphabet[(tmp >>= 6) & 0x3D];
            bit += 3;
            idx += 4;
        }
        return new String(out, 0, bits);
    }

    public static String getUUIDBits(int bits, Function<String, Boolean> ok) {
        return UUIDBits.getUUIDBits(bits, ok, 10);
    }

    public static String getUUIDBits(int bits, Function<String, Boolean> ok, int max) {
        String uuidBits;
        int i = 0;
        do {
            uuidBits = UUIDBits.getUUIDBits(bits);
            if (++i <= max) continue;
            return null;
        } while (!ok.apply(uuidBits).booleanValue());
        return uuidBits;
    }
}

