/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import cn.omisheep.commons.util.StringUtils;
import cn.omisheep.commons.util.TimeUtils;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskBuilder {
    private static final AtomicInteger taskNumber = new AtomicInteger(1);
    private static ScheduledExecutorService timer;

    private TaskBuilder() {
        throw new UnsupportedOperationException();
    }

    public static ScheduledFuture<?> schedule(Runnable task, String periodTimeVal) {
        return TaskBuilder.schedule(task, TimeUtils.parseTimeValue(periodTimeVal), TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> schedule(Runnable task, long period, TimeUnit timeUnit) {
        if (period == 0L) {
            return null;
        }
        return timer.scheduleAtFixedRate(task, 0L, period, timeUnit);
    }

    public static ScheduledFuture<?> scheduleDelay(Runnable task, String delayTimeVal, String periodTimeVal) {
        return TaskBuilder.scheduleDelay(task, TimeUtils.parseTimeValue(delayTimeVal), TimeUtils.parseTimeValue(periodTimeVal), TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> scheduleDelay(Runnable task, long delay, long period, TimeUnit timeUnit) {
        if (period == 0L) {
            return TaskBuilder.scheduleOnceDelay(task, delay, timeUnit);
        }
        return timer.scheduleAtFixedRate(task, delay, period, timeUnit);
    }

    public static ScheduledFuture<?> scheduleOnce(Runnable task) {
        return timer.schedule(task, 0L, TimeUnit.MICROSECONDS);
    }

    public static ScheduledFuture<?> scheduleOnceDelay(Runnable task, String delayTimeVal) {
        return TaskBuilder.scheduleOnceDelay(task, TimeUtils.parseTimeValue(delayTimeVal), TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> scheduleOnceDelay(Runnable task, long delay, TimeUnit timeUnit) {
        if (delay == 0L) {
            return TaskBuilder.scheduleOnce(task);
        }
        return timer.schedule(task, delay, timeUnit);
    }

    public static void create() {
        if (null != timer) {
            TaskBuilder.shutdownNow();
        }
        timer = new ScheduledThreadPoolExecutor(1, r -> TaskBuilder.newThread(r, StringUtils.format("Timer-{}", taskNumber.getAndIncrement())));
    }

    public static void shutdown() {
        if (null != timer) {
            timer.shutdown();
        }
    }

    public static List<Runnable> shutdownNow() {
        if (null != timer) {
            return timer.shutdownNow();
        }
        return null;
    }

    private static Thread newThread(Runnable runnable, String name) {
        Thread t = new Thread(null, runnable, name);
        t.setDaemon(false);
        return t;
    }

    static {
        TaskBuilder.create();
    }
}

