/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;

public class StringUtils {
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);

    private StringUtils() {
        throw new UnsupportedOperationException();
    }

    public static String format(String formatMsg, Object ... args) {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = Arrays.stream(args).iterator();
        int i = 0;
        while (i < formatMsg.length()) {
            int _end = formatMsg.indexOf("{}", i);
            if (_end == -1) {
                sb.append(formatMsg, i, formatMsg.length());
                break;
            }
            if (iterator.hasNext()) {
                sb.append(formatMsg, i, _end).append(iterator.next());
                i = _end + 2;
                continue;
            }
            sb.append(formatMsg, i, formatMsg.length());
            break;
        }
        return sb.toString();
    }

    public static boolean hasText(String str) {
        return str != null && !str.isEmpty() && StringUtils.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || "".contentEquals(str);
    }

    public static String bytesToHexStr(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }
}

