/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamingUtils {
    private static final Pattern HUMP_PATTERN = Pattern.compile("[A-Z]");
    private static final Pattern UNDERLINE_PATTERN = Pattern.compile("_(\\w)");

    private NamingUtils() {
        throw new UnsupportedOperationException();
    }

    public static String humpToMidline(String name) {
        Matcher matcher = HUMP_PATTERN.matcher(name);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "-" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String humpToUnderline(String name) {
        Matcher matcher = HUMP_PATTERN.matcher(name);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String underlineToHump(String name) {
        name = name.toLowerCase();
        Matcher matcher = UNDERLINE_PATTERN.matcher(name);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

