/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import cn.omisheep.commons.util.Color;
import cn.omisheep.commons.util.StringUtils;
import java.util.Arrays;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogHelper {
    private final String className;
    private final Logger logger;
    private static final Filter filter = record -> record.getMessage() != null && !record.getMessage().contains("no log");

    public LogHelper(Class<?> clazz) {
        this.className = clazz.getName().trim();
        this.logger = Logger.getLogger(this.className);
        this.logger.setFilter(filter);
    }

    public static void p(Object ... msg) {
        Logger.getGlobal().info(Arrays.toString(msg));
    }

    public static LogHelper getLog(Class<?> clazz) {
        return new LogHelper(clazz);
    }

    public void log(Level level, Color color, String msg, Object ... params) {
        this.logger.logp(level, this.className, this.getMethodName(), color.str(StringUtils.format(msg, params)));
    }

    public void log(Level level, String msg, Object ... params) {
        this.logger.logp(level, this.className, this.getMethodName(), StringUtils.format(msg, params));
    }

    public void log(String msg, Object ... params) {
        this.log(Level.INFO, msg, params);
    }

    public void debug(String msg, Object ... params) {
        this.log(Level.INFO, msg, new Object[]{Color.GREEN, params});
    }

    public void warn(String msg, Object ... params) {
        this.log(Level.INFO, msg, new Object[]{Color.GREEN, params});
    }

    public void error(String msg, Object ... params) {
        this.log(Level.SEVERE, msg, new Object[]{Color.RED, params});
    }

    public void error(Throwable e) {
        this.log(Level.SEVERE, e.getMessage(), new Object[]{Color.RED});
    }

    private String getMethodName() {
        StackTraceElement frame = null;
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            String clzName = ste.getClassName();
            if (ste.isNativeMethod() || clzName.equals(Thread.class.getName()) || clzName.equals(this.getClass().getName()) || !clzName.equals(this.className)) continue;
            frame = ste;
            break;
        }
        if (frame != null) {
            return String.format("%s (%s:%s)", frame.getMethodName(), frame.getFileName(), frame.getLineNumber());
        }
        return null;
    }
}

