/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class KeyMatchUtils {
    private KeyMatchUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean stringMatch(String pattern, String string, boolean nocase) {
        char[] patternChars = pattern.toCharArray();
        char[] stringChars = string.toCharArray();
        return KeyMatchUtils.stringMatchLen(0, patternChars, 0, stringChars, nocase);
    }

    private static boolean stringMatchLen(int pIndex, char[] pattern, int sIndex, char[] string, boolean noCase) {
        while (pattern.length - pIndex > 0 && string.length - sIndex > 0) {
            switch (pattern[pIndex]) {
                case '*': {
                    while (pattern.length - pIndex > 0 && pIndex + 1 < pattern.length && pattern[pIndex + 1] == '*') {
                        ++pIndex;
                    }
                    if (pattern.length - pIndex == 1) {
                        return true;
                    }
                    while (string.length - sIndex > 0) {
                        if (KeyMatchUtils.stringMatchLen(pIndex + 1, pattern, sIndex, string, noCase)) {
                            return true;
                        }
                        ++sIndex;
                    }
                    return false;
                }
                case '?': {
                    ++sIndex;
                    break;
                }
                case '[': {
                    boolean not;
                    boolean bl = not = pattern[++pIndex] == '^';
                    if (not) {
                        ++pIndex;
                    }
                    boolean match = false;
                    while (true) {
                        if (pattern[pIndex] == '\\' && pattern.length - pIndex >= 2) {
                            if (pattern[++pIndex] == string[sIndex]) {
                                match = true;
                            }
                        } else {
                            if (pattern[pIndex] == ']') break;
                            if (pattern.length - pIndex >= 3 && pIndex + 1 < pattern.length && pattern[pIndex + 1] == '-') {
                                int start = pattern[pIndex];
                                int end = pIndex + 2 < pattern.length ? pattern[pIndex + 2] : 0;
                                int c = string[sIndex];
                                if (start > end) {
                                    int t = start;
                                    start = end;
                                    end = t;
                                }
                                if (noCase) {
                                    start = Character.toLowerCase(start);
                                    end = Character.toLowerCase(end);
                                    c = Character.toLowerCase(c);
                                }
                                pIndex += 2;
                                if (c >= start && c <= end) {
                                    match = true;
                                }
                            } else if (!noCase) {
                                if (pattern[pIndex] == string[sIndex]) {
                                    match = true;
                                }
                            } else if (Character.toLowerCase(pattern[pIndex]) == Character.toLowerCase(string[sIndex])) {
                                match = true;
                            }
                        }
                        ++pIndex;
                    }
                    if (not) {
                        boolean bl2 = match = !match;
                    }
                    if (!match) {
                        return false;
                    }
                    ++sIndex;
                    break;
                }
                case '\\': {
                    if (pattern.length - pIndex >= 2) {
                        ++pIndex;
                    }
                }
                default: {
                    if (!noCase ? pattern[pIndex] != string[sIndex] : Character.toLowerCase(pattern[pIndex]) != Character.toLowerCase(string[sIndex])) {
                        return false;
                    }
                    ++sIndex;
                }
            }
            ++pIndex;
            if (string.length - sIndex != 0) continue;
            while (pIndex < pattern.length && pattern[pIndex] == '*' && pattern.length - pIndex == 1) {
                ++pIndex;
            }
            break block6;
        }
        return pattern.length - pIndex == 0 && string.length - sIndex == 0;
    }

    public static List<String> matchPatterns(String key, Collection<String> keyPatterns) {
        return keyPatterns.stream().filter(k -> KeyMatchUtils.stringMatch(k, key, false)).collect(Collectors.toList());
    }

    public static List<String> matchPatterns(Collection<String> keys, Collection<String> keyPatterns) {
        return keyPatterns.stream().filter(k -> keys.stream().anyMatch(key -> KeyMatchUtils.stringMatch(k, key, false))).collect(Collectors.toList());
    }
}

