/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.encryption;

import cn.omisheep.commons.util.LogHelper;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;

public class SymmetriCipherInfo {
    private static final LogHelper log = LogHelper.getLog(SymmetriCipherInfo.class);
    private String algorithm;
    private int keySize;

    private SymmetriCipherInfo() {
        throw new UnsupportedOperationException();
    }

    public SymmetriCipherInfo(String algorithm, int keySize) {
        this.algorithm = algorithm;
        this.keySize = keySize;
    }

    public static byte[] doCipher(String algorithm, int mode, Key key, AlgorithmParameterSpec params, byte[] s) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            if (params != null) {
                try {
                    cipher.init(mode, key, params);
                }
                catch (InvalidAlgorithmParameterException e) {
                    log.error(e);
                }
            } else {
                cipher.init(mode, key);
            }
            return cipher.doFinal(s);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            log.error(e);
            return null;
        }
    }

    static byte[] doCipher(SymmetriCipherInfo ci, int mode, String key, byte[] bytes) {
        SecretKey _key;
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            sr.setSeed(key.getBytes());
            _key = SymmetriCipherInfo.getSecretKey(ci.getCipherAlgorithm(), sr, ci.getKeySize());
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e);
            return null;
        }
        return SymmetriCipherInfo.doCipher(ci.getCipherAlgorithm(), mode, _key, null, bytes);
    }

    public static SecretKey getSecretKey(String algorithm, SecureRandom secure, Integer keySize) {
        KeyGenerator generator;
        try {
            generator = KeyGenerator.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e);
            return null;
        }
        if (secure != null) {
            if (keySize == null) {
                generator.init(secure);
            } else {
                generator.init(keySize, secure);
            }
        }
        return generator.generateKey();
    }

    public static String getSecretKey(String algorithm, SecureRandom secure) {
        try {
            return Base64.encodeBase64String((byte[])SymmetriCipherInfo.getSecretKey(algorithm, secure, null).getEncoded());
        }
        catch (Exception e) {
            log.error(e);
            return "";
        }
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public String getCipherAlgorithm() {
        return this.algorithm;
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.algorithm = cipherAlgorithm;
    }
}

