/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.encryption;

import cn.omisheep.commons.encryption.SymmetriCipherInfo;
import cn.omisheep.commons.util.LogHelper;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Objects;
import java.util.Random;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class SymmetriCipher {
    private static final LogHelper log = LogHelper.getLog(SymmetriCipher.class);
    private static final SymmetriCipherInfo AES = new SymmetriCipherInfo("AES", 128);
    private static final SymmetriCipherInfo DES = new SymmetriCipherInfo("DES", 56);
    private static final String TripleDES_ALGORITHM = "DESede";
    private static final String KEY_PBE = "PBEWITHMD5andDES";
    private static final int SALT_COUNT = 100;

    private SymmetriCipher() {
        throw new UnsupportedOperationException();
    }

    public static String AES_Encrypt(String str, String key) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        bytes = SymmetriCipherInfo.doCipher(AES, 1, key, bytes);
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static String AES_Decrypt(String str, String key) {
        byte[] b = SymmetriCipherInfo.doCipher(AES, 2, key, Base64.decodeBase64((String)str));
        if (b == null || b.length == 0) {
            return null;
        }
        return new String(b, StandardCharsets.UTF_8);
    }

    public static String DES_Encrypt(String str, String key) {
        return Base64.encodeBase64String((byte[])SymmetriCipherInfo.doCipher(DES, 1, key, str.getBytes(StandardCharsets.UTF_8)));
    }

    public static String DES_Decrypt(String str, String key) {
        return new String(Objects.requireNonNull(SymmetriCipherInfo.doCipher(DES, 2, key, Base64.decodeBase64((String)str))), StandardCharsets.UTF_8);
    }

    private static byte[] initTripleDES(boolean isEnc, byte[] key, byte[] data) {
        SecretKeySpec deskey = new SecretKeySpec(key, TripleDES_ALGORITHM);
        int mode = isEnc ? 1 : 2;
        return SymmetriCipherInfo.doCipher(TripleDES_ALGORITHM, mode, deskey, null, data);
    }

    public static byte[] encryptTripleDES(byte[] key, String data) {
        return SymmetriCipher.initTripleDES(true, key, data.getBytes());
    }

    public static String decryptTripleDES(byte[] key, byte[] data) {
        return new String(SymmetriCipher.initTripleDES(false, key, data));
    }

    public static byte[] init() {
        byte[] salt = new byte[8];
        new Random().nextBytes(salt);
        return salt;
    }

    private static byte[] initPBE(boolean isEnc, String key, byte[] salt, byte[] data) {
        SecretKey k = null;
        try {
            k = SecretKeyFactory.getInstance(KEY_PBE).generateSecret(new PBEKeySpec(key.toCharArray()));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            log.error(e);
        }
        PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, 100);
        int mode = isEnc ? 1 : 2;
        return SymmetriCipherInfo.doCipher(KEY_PBE, mode, k, parameterSpec, data);
    }

    public static byte[] encryptPBE(String key, byte[] salt, String data) {
        return SymmetriCipher.initPBE(true, key, salt, data.getBytes());
    }

    public static String decryptPBE(String key, byte[] salt, byte[] data) {
        return new String(SymmetriCipher.initPBE(false, key, salt, data));
    }
}

