/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.encryption;

import cn.omisheep.commons.encryption.SymmetriCipherInfo;
import cn.omisheep.commons.util.LogHelper;
import cn.omisheep.commons.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class Digest {
    private static final LogHelper log = LogHelper.getLog(Digest.class);
    private static final String KEY_MAC = "HmacMD5";

    private Digest() {
        throw new UnsupportedOperationException();
    }

    public static String hash(String hash, String str) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(hash);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e);
            return null;
        }
        md.update(str.getBytes(StandardCharsets.UTF_8));
        return StringUtils.bytesToHexStr(md.digest()).toLowerCase();
    }

    public static String md5(String str) {
        return Digest.hash("MD5", str);
    }

    public static String getSHA1(String str) {
        return Digest.hash("SHA1", str);
    }

    public static String getSHA256(String str) {
        return Digest.hash("SHA-256", str);
    }

    public static String getHMAC_Key() {
        return SymmetriCipherInfo.getSecretKey(KEY_MAC, null);
    }

    public static String getHMAC(String data, String key) {
        if (!StringUtils.hasText(data)) {
            return null;
        }
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(Base64.decodeBase64((String)key), KEY_MAC);
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes());
            if (bytes == null) {
                return "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return StringUtils.bytesToHexStr(bytes);
    }

    public static byte[] getMac(String algorithm, String key, String data) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), algorithm));
            return mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            log.error(e);
            return null;
        }
    }

    public static String getMacAsStr(String algorithm, String key, String data) {
        return Base64.encodeBase64String((byte[])Objects.requireNonNull(Digest.getMac(algorithm, key, data)));
    }

    public static String doHmacSHA1(String key, String data) {
        return Digest.getMacAsStr("HmacSHA1", key, data);
    }

    public static String doHmacSHA256(String key, String data) {
        return Digest.getMacAsStr("HmacSHA256", key, data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String calcFileMD5(File file, byte[] bytes) {
        try (ByteArrayInputStream stream = file != null ? Files.newInputStream(file.toPath(), StandardOpenOption.READ) : new ByteArrayInputStream(bytes);){
            int len;
            byte[] buf = new byte[8192];
            MessageDigest digest = MessageDigest.getInstance("MD5");
            while ((len = stream.read(buf)) > 0) {
                digest.update(buf, 0, len);
            }
            String string = StringUtils.bytesToHexStr(digest.digest());
            return string;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.error(e);
            return "";
        }
    }
}

