/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.encryption;

import cn.omisheep.commons.encryption.SymmetriCipherInfo;
import cn.omisheep.commons.util.StringUtils;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.apache.commons.codec.binary.Base64;

public class DES {
    private static final String KEY_DES = "DES";
    private static final String KEY_AES = "AES";

    private DES() {
        throw new UnsupportedOperationException();
    }

    public static String init(String seed) {
        SecureRandom secure = null;
        String str = "";
        try {
            secure = new SecureRandom();
            str = SymmetriCipherInfo.getSecretKey(KEY_DES, secure);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    private static Key byteToKey(byte[] key) {
        try {
            return SecretKeyFactory.getInstance(KEY_DES).generateSecret(new DESKeySpec(key));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptDES(String data, String key) {
        Key k = DES.byteToKey(Base64.decodeBase64((String)key));
        byte[] bytes = SymmetriCipherInfo.doCipher(KEY_DES, 2, k, null, DES.hexString2Bytes(data));
        return new String(bytes);
    }

    public static String encryptDES(String data, String key) {
        Key k = DES.byteToKey(Base64.decodeBase64((String)key));
        byte[] bytes = SymmetriCipherInfo.doCipher(KEY_DES, 1, k, null, data.getBytes());
        return StringUtils.bytesToHexStr(bytes);
    }

    public static String changeHex(int a) {
        String str = "";
        String tmp = "";
        for (int i = 0; i < 4; ++i) {
            tmp = Integer.toHexString((a >> i * 8) % 256 & 0xFF);
            if (tmp.length() < 2) {
                tmp = "0" + tmp;
            }
            str = str + tmp;
        }
        return str;
    }

    public static byte[] hexString2Bytes(String hexstr) {
        byte[] b = new byte[hexstr.length() / 2];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            char c0 = hexstr.charAt(j++);
            char c1 = hexstr.charAt(j++);
            b[i] = (byte)(DES.parse(c0) << 4 | DES.parse(c1));
        }
        return b;
    }

    private static int parse(char c) {
        if (c >= 'a') {
            return c - 97 + 10 & 0xF;
        }
        if (c >= 'A') {
            return c - 65 + 10 & 0xF;
        }
        return c - 48 & 0xF;
    }
}

