package cn.omisheep.commons.util;

import java.util.concurrent.TimeUnit;

/**
 * @author zhouxinchen[1269670415@qq.com]
 * @version 1.0.0
 * @since 1.0.0
 */
public class DebugUtils {
    public static long start(String methodName) {
        Console.info("[Debug] Timing begins: located at {} ", methodName);
        return TimeUtils.nowTime();
    }

    public static void end(String methodName, long start, TimeUnit timeUnit) {
        long convert = timeUnit.convert((TimeUtils.nowTime() - start), TimeUnit.MILLISECONDS);
        Console.info("[Debug] Timing end: {} time cost [ {} ({}) ] ", methodName, convert, TimeUtils.timeShortName(timeUnit));
    }

    public static void end(String methodName, long start, String timeUnit) {
        end(methodName, start, TimeUnit.valueOf(timeUnit));
    }
}
