package cn.omisheep.commons.util;

import java.util.concurrent.*;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * 异步执行方法
 *
 * @author zhouxinchen[1269670415@qq.com]
 * @version 1.0.0
 * @since 1.0.0
 */
public abstract class Async {

    private static ExecutorService executor;

    static {
        create();
    }

    public static CompletableFuture<Void> run(Runnable task) {
        return CompletableFuture.runAsync(task, executor);
    }

    public static CompletableFuture<Void> combine(Runnable task1, Runnable task2) {
        return run(task1).thenCombineAsync(run(task2), (void1, void2) -> null, executor);
    }

    public static <U> CompletableFuture<U> supply(Supplier<U> task) {
        return CompletableFuture.supplyAsync(task, executor);
    }

    public static CompletableFuture<Object> anyOf(CompletableFuture<?>... tasks) {
        return CompletableFuture.anyOf(tasks);
    }

    public static CompletableFuture<Void> allOf(CompletableFuture<?>... tasks) {
        return CompletableFuture.allOf(tasks);
    }

    public static <U1, U2, V> CompletableFuture<? extends V> supplyCombine(Supplier<U1> task1, Supplier<U2> task2, BiFunction<? super U1, ? super U2, ? extends V> returnFn) {
        return supply(task1).thenCombineAsync(supply(task2), returnFn);
    }

    public static <U1, U2> CompletableFuture<U2> supplyComposeAsync(Supplier<U1> task1, Function<? super U1, ? extends CompletionStage<U2>> task2) {
        return supply(task1).thenComposeAsync(task2, executor);
    }

    public static boolean isSuccessFuture(CompletableFuture<?> future) {
        return future.isDone() && !future.isCompletedExceptionally() && !future.isCancelled();
    }

    public static boolean joinAndCheck(CompletableFuture<Void> future) {
        future.join();
        return future.isDone() && !future.isCompletedExceptionally() && !future.isCancelled();
    }


    public static void create() {
        int max = Runtime.getRuntime().availableProcessors();
        if (max <= 4) max = 4;
        if (max > 12) max = 12;
        executor = new ThreadPoolExecutor(4, max,
                60L, TimeUnit.SECONDS,
                new LinkedBlockingQueue<>());
    }

    public static void shutdown() {
        executor.shutdown();
    }

}
