/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.RequiredTypeException;
import java.util.Date;

public class Utils {
    public static boolean stringMatch(String pattern, String string, boolean nocase) {
        char[] patternChars = pattern.toCharArray();
        char[] stringChars = string.toCharArray();
        return Utils.stringMatchLen(0, patternChars, 0, stringChars, nocase);
    }

    private static boolean stringMatchLen(int pIndex, char[] pattern, int sIndex, char[] string, boolean noCase) {
        while (pattern.length - pIndex > 0 && string.length - sIndex > 0) {
            switch (pattern[pIndex]) {
                case '*': {
                    while (pattern.length - pIndex > 0 && pIndex + 1 < pattern.length && pattern[pIndex + 1] == '*') {
                        ++pIndex;
                    }
                    if (pattern.length - pIndex == 1) {
                        return true;
                    }
                    while (string.length - sIndex > 0) {
                        if (Utils.stringMatchLen(pIndex + 1, pattern, sIndex, string, noCase)) {
                            return true;
                        }
                        ++sIndex;
                    }
                    return false;
                }
                case '?': {
                    ++sIndex;
                    break;
                }
                case '[': {
                    boolean not;
                    boolean bl = not = pattern[++pIndex] == '^';
                    if (not) {
                        ++pIndex;
                    }
                    boolean match = false;
                    while (true) {
                        if (pattern[pIndex] == '\\' && pattern.length - pIndex >= 2) {
                            if (pattern[++pIndex] == string[sIndex]) {
                                match = true;
                            }
                        } else {
                            if (pattern[pIndex] == ']') break;
                            if (pattern.length - pIndex >= 3 && pIndex + 1 < pattern.length && pattern[pIndex + 1] == '-') {
                                int start = pattern[pIndex];
                                int end = pIndex + 2 < pattern.length ? pattern[pIndex + 2] : 0;
                                int c = string[sIndex];
                                if (start > end) {
                                    int t = start;
                                    start = end;
                                    end = t;
                                }
                                if (noCase) {
                                    start = Character.toLowerCase(start);
                                    end = Character.toLowerCase(end);
                                    c = Character.toLowerCase(c);
                                }
                                pIndex += 2;
                                if (c >= start && c <= end) {
                                    match = true;
                                }
                            } else if (!noCase) {
                                if (pattern[pIndex] == string[sIndex]) {
                                    match = true;
                                }
                            } else if (Character.toLowerCase(pattern[pIndex]) == Character.toLowerCase(string[sIndex])) {
                                match = true;
                            }
                        }
                        ++pIndex;
                    }
                    if (not) {
                        boolean bl2 = match = !match;
                    }
                    if (!match) {
                        return false;
                    }
                    ++sIndex;
                    break;
                }
                case '\\': {
                    if (pattern.length - pIndex >= 2) {
                        ++pIndex;
                    }
                }
                default: {
                    if (!noCase ? pattern[pIndex] != string[sIndex] : Character.toLowerCase(pattern[pIndex]) != Character.toLowerCase(string[sIndex])) {
                        return false;
                    }
                    ++sIndex;
                }
            }
            ++pIndex;
            if (string.length - sIndex != 0) continue;
            while (pIndex < pattern.length && pattern[pIndex] == '*' && pattern.length - pIndex == 1) {
                ++pIndex;
            }
            break block6;
        }
        return pattern.length - pIndex == 0 && string.length - sIndex == 0;
    }

    public static String beautifulJson(Object o) {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            return JSON.toJSONString((Object)o, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static <T> T castValue(Object value, Class<T> requiredType) {
        if (value == null) {
            return null;
        }
        if (requiredType == Date.class && value instanceof Long) {
            value = new Date((Long)value);
        }
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            if (requiredType == Long.class) {
                value = (long)intValue;
            } else if (requiredType == Short.class && Short.MIN_VALUE <= intValue && intValue <= Short.MAX_VALUE) {
                value = (short)intValue;
            } else if (requiredType == Byte.class && -128 <= intValue && intValue <= 127) {
                value = (byte)intValue;
            }
        }
        if (!requiredType.isInstance(value)) {
            throw new RequiredTypeException("Expected value to be of type: " + requiredType + ", but was " + value.getClass());
        }
        return requiredType.cast(value);
    }
}

