/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.commons.util;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    private static final String blank = " ";
    private static final String empty = "";
    private static final String zero = "0";
    private static final String yyyyMMddhhmmss_pattern = "yyyy-MM-dd hh:mm:ss";
    private static final String yyyyMMdd_pattern = "yyyy-MM-dd";
    private static final String yyyyMM_pattern = "yyyy-MM";
    private static final String one_day = "1d";

    public static long parseTimeValueTotal(String ... timeVals) {
        long c = 0L;
        for (String timeVal : timeVals) {
            c += TimeUtils.parseTimeValue(timeVal);
        }
        return c;
    }

    public static long parseTimeValue(String timeVal) {
        return TimeUtils.parseTimeValue(timeVal, blank);
    }

    public static long parseTimeValueToSecond(String timeVal) {
        return TimeUnit.MILLISECONDS.toSeconds(TimeUtils.parseTimeValue(timeVal, blank));
    }

    public static long parseTimeValue(String timeVal, String delimiter) {
        if (timeVal == null || timeVal.equals(empty) || timeVal.equals(zero)) {
            return 0L;
        }
        String[] s = timeVal.trim().split(delimiter);
        long time = 0L;
        for (String val : s) {
            time += TimeUtils.parseTime(val);
        }
        return time;
    }

    public static String parseTime(long ms) {
        return TimeUtils.parseTime(ms, blank);
    }

    public static String parseTime(long ms, String delimiter) {
        String _ms = ms % 1000L + TimeUnitShortName.MILLISECONDS.name;
        if (ms < 1000L) {
            return _ms;
        }
        long s = ms / 1000L;
        String _s = s % 60L + TimeUnitShortName.SECONDS.name + delimiter + _ms;
        if (s < 60L) {
            return _s;
        }
        long m = s / 60L;
        String _m = m % 60L + TimeUnitShortName.MINUTES.name + delimiter + _s;
        if (m < 60L) {
            return _m;
        }
        long h = m / 60L;
        String _h = h % 60L + TimeUnitShortName.HOURS.name + delimiter + _m;
        if (h < 24L) {
            return _h;
        }
        long d = h / 24L;
        return d + TimeUnitShortName.DAYS.name + delimiter + _h;
    }

    private static long parseTime(String timeVal) {
        String normalized = timeVal.toLowerCase(Locale.ROOT).trim();
        if (normalized.endsWith(TimeUnitShortName.DAYS.name)) {
            return TimeUnit.DAYS.toMillis(TimeUtils.trim(normalized, TimeUnitShortName.DAYS.name));
        }
        if (normalized.endsWith(TimeUnitShortName.HOURS.name)) {
            return TimeUnit.HOURS.toMillis(TimeUtils.trim(normalized, TimeUnitShortName.HOURS.name));
        }
        if (normalized.endsWith(TimeUnitShortName.MINUTES.name)) {
            return TimeUnit.MINUTES.toMillis(TimeUtils.trim(normalized, TimeUnitShortName.MINUTES.name));
        }
        if (normalized.endsWith(TimeUnitShortName.MILLISECONDS.name)) {
            return TimeUnit.MILLISECONDS.toMillis(TimeUtils.trim(normalized, TimeUnitShortName.MILLISECONDS.name));
        }
        if (normalized.endsWith(TimeUnitShortName.SECONDS.name)) {
            return TimeUnit.SECONDS.toMillis(TimeUtils.trim(normalized, TimeUnitShortName.SECONDS.name));
        }
        return 0L;
    }

    private static long trim(String normalized, String suffix) {
        String s = normalized.substring(0, normalized.length() - suffix.length()).trim();
        try {
            long value = Long.parseLong(s);
            if (value >= 0L) {
                return value;
            }
        }
        catch (Exception e) {
            return 0L;
        }
        return 0L;
    }

    public static long nowTime() {
        return TimeUtils.now().getTime();
    }

    public static Date now() {
        return Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime nowDateTime() {
        return LocalDateTime.now();
    }

    public static String nowString() {
        return TimeUtils.format(TimeUtils.now());
    }

    public static String nowString(String pattern) {
        return TimeUtils.format(pattern, TimeUtils.now());
    }

    public static long diff(long other) {
        return TimeUtils.nowTime() - other;
    }

    public static Date datePlus(Date date, String plusTimeVal) {
        return TimeUtils.datePlus(date, TimeUtils.parseTimeValue(plusTimeVal));
    }

    public static Date datePlus(Date date, long plusTime) {
        return Date.from(date.toInstant().plus(plusTime, ChronoUnit.MILLIS).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date plus(String plusTimeVal) {
        return TimeUtils.plus(TimeUtils.parseTimeValue(plusTimeVal));
    }

    public static Date plus(long plusTime) {
        return Date.from(TimeUtils.nowPlus(plusTime).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date dateMinus(Date date, String minusTimeVal) {
        return TimeUtils.dateMinus(date, TimeUtils.parseTimeValue(minusTimeVal));
    }

    public static Date dateMinus(Date date, long minusTime) {
        return Date.from(date.toInstant().minus(minusTime, ChronoUnit.MILLIS).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date minus(long minusTime) {
        return Date.from(TimeUtils.nowMinus(minusTime).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date minus(String minusTimeVal) {
        return TimeUtils.minus(TimeUtils.parseTimeValue(minusTimeVal));
    }

    public static String format(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(yyyyMMddhhmmss_pattern);
        return simpleDateFormat.format(date);
    }

    public static String format(String pattern, Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(date);
    }

    public static int maxDaysInMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        return cal.getActualMaximum(5);
    }

    public static int[] currentYearAndMonth() {
        LocalDateTime now = LocalDateTime.now();
        return new int[]{now.getYear(), now.getMonthValue()};
    }

    public static int[] yesterdayYearAndMonth() {
        LocalDateTime localDateTime = TimeUtils.nowMinus(one_day);
        return new int[]{localDateTime.getYear(), localDateTime.getMonthValue()};
    }

    public static int currentYear() {
        return LocalDateTime.now().getYear();
    }

    public static int currentMonth() {
        return LocalDateTime.now().getMonthValue();
    }

    public static int currentDay() {
        return LocalDateTime.now().getDayOfMonth();
    }

    public static int currentHour() {
        return LocalDateTime.now().getHour();
    }

    public static int currentMinute() {
        return LocalDateTime.now().getMinute();
    }

    public static LocalDateTime nowPlus(long plusTime) {
        return LocalDateTime.now().plus(plusTime, ChronoUnit.MILLIS);
    }

    public static LocalDateTime nowPlus(String plusTimeVal) {
        return LocalDateTime.now().plus(TimeUtils.parseTimeValue(plusTimeVal), ChronoUnit.MILLIS);
    }

    public static LocalDateTime nowMinus(long minusTime) {
        return LocalDateTime.now().minus(minusTime, ChronoUnit.MILLIS);
    }

    public static LocalDateTime nowMinus(String minusTimeVal) {
        return LocalDateTime.now().minus(TimeUtils.parseTimeValue(minusTimeVal), ChronoUnit.MILLIS);
    }

    public static Date nextIntactDateForMinute() {
        Calendar ca = Calendar.getInstance();
        ca.set(13, 0);
        ca.set(14, 0);
        ca.add(12, 1);
        return ca.getTime();
    }

    public static Date nextIntactDateForDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(10, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        ca.add(5, 1);
        return ca.getTime();
    }

    public static boolean isThisWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        int currentWeek = calendar.get(3);
        calendar.setTime(date);
        int chooseWeek = calendar.get(3);
        return chooseWeek == currentWeek;
    }

    public static boolean isToday(Date date) {
        return TimeUtils.isThisTime(date, yyyyMMdd_pattern);
    }

    public static boolean isThisMonth(Date date) {
        return TimeUtils.isThisTime(date, yyyyMM_pattern);
    }

    private static boolean isThisTime(Date date, String pattern) {
        return TimeUtils.format(pattern, date).equals(TimeUtils.format(pattern, new Date()));
    }

    public static String timeShortName(TimeUnit unit) {
        return TimeUnitShortName.valueOf(unit.name()).name;
    }

    private static enum TimeUnitShortName {
        NANOSECONDS(TimeUnit.NANOSECONDS, "ns"),
        MICROSECONDS(TimeUnit.MICROSECONDS, "\u03bcs"),
        MILLISECONDS(TimeUnit.MILLISECONDS, "ms"),
        SECONDS(TimeUnit.SECONDS, "s"),
        MINUTES(TimeUnit.MINUTES, "m"),
        HOURS(TimeUnit.HOURS, "h"),
        DAYS(TimeUnit.DAYS, "d");

        private final TimeUnit unit;
        private final String name;

        private TimeUnitShortName(TimeUnit unit, String name) {
            this.unit = unit;
            this.name = name;
        }
    }
}

